/**
 * Copyright gaziya ( http://wonderfl.net/user/gaziya )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qB0m
 */

// forked from gaziya's sphere
package {
    import flash.display.Bitmap;
    import flash.geom.Point;
    import flash.display.BitmapData;
    import flash.geom.PerspectiveProjection;
    import flash.utils.getTimer;
    import flash.geom.Vector3D;
    import flash.geom.Utils3D;
    import flash.geom.Matrix3D;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            var noise:BitmapData = new BitmapData(300,300)
            noise.perlinNoise(70, 70, 5, Math.random() * 100, true, true, 5, true)
            var texture:BitmapData = new BitmapData(300,300,false)
            var bitmap:Bitmap = addChild(new Bitmap(texture))as Bitmap
            bitmap.width = 100
            bitmap.height = 100
            var paletteR:Array = [];
            var paletteG:Array = [];
            var paletteB:Array = [];
            var seaHeight:uint = 0x90
            var r:Number;
            for (i=0; i<256; i++) {
                if (i >= seaHeight) {
                    r = (i - seaHeight) / (256 - seaHeight);
                    if (r > 0.7) {
                        paletteR[i] = (0x99 + 0x66 * (r - 0.7) / (1 - 0.7)) << 16;
                        paletteG[i] = (0x66 + 0x99 * (r - 0.7) / (1 - 0.7)) << 8;
                        paletteB[i] = (0x00 + 0xFF * (r - 0.7) / (1 - 0.7));
                    } else if (r > 0.15) {
                        paletteR[i] = (0x00 + 0x99 * (r - 0.15) / (0.7 - 0.15)) << 16;
                        paletteG[i] = (0xCC - 0x66 * (r - 0.15) / (0.7 - 0.15)) << 8;
                        paletteB[i] = (0x00 + 0x00 * (r - 0.15) / (0.7 - 0.15));
                    } else {
                        paletteR[i] = (0xCC - 0xCC * r / 0.15) << 16;
                        paletteG[i] = (0x99 + 0x33 * r / 0.15) << 8;
                        paletteB[i] = (0x33 - 0x33 * r / 0.15);
                    }
                } else {
                    r = i / seaHeight;
                    paletteR[i] = 0;
                    paletteG[i] = Math.pow(r, 5) * 0x66 << 8;
                    paletteB[i] = (r * 0.5 + 0.5) * 0xFF;
                }
            }
            texture.paletteMap(noise, noise.rect,new Point, paletteR, paletteG, paletteB)
            var sphere:Object = new Object
            sphere.vertices = new Vector.<Number>
            sphere.indices = new Vector.<int>
            sphere.uvtData = new Vector.<Number>
            var xSegs:uint = 24
            var ySegs:uint = 16
            for (var y:int=0; y <= ySegs; y++) {
                for (var x:int=0; x <= xSegs; x++) {
                    sphere.vertices.push(
                        Math.sin(y/ySegs*Math.PI)*Math.cos(x/xSegs*2*Math.PI),
                        Math.cos(y/ySegs*Math.PI),
                        Math.sin(y/ySegs*Math.PI)*Math.sin(x/xSegs*2*Math.PI)
                    )
                    sphere.uvtData.push(x/xSegs, y/ySegs, 0)
                    var i:int = (xSegs+1)*y+x
                    if (x < xSegs && y < ySegs) {
                        sphere.indices.push(
                            i, i+1, i+xSegs+1,
                            i+1, i+xSegs+2, i+xSegs+1
                        )
                    }                        
                }
            }          
            
            var pers:PerspectiveProjection = new PerspectiveProjection
            var persMatrix:Matrix3D = pers.toMatrix3D()
            var worldMatrix:Matrix3D = new Matrix3D          
            addEventListener(Event.ENTER_FRAME, function(e:Event):void{
                with (worldMatrix) {
                    identity()
                    appendRotation(getTimer()*0.03,Vector3D.Y_AXIS)
                    appendRotation(15,Vector3D.X_AXIS)
                    appendTranslation(0,0,-3)
                    append(persMatrix)
                }
                var persVerts:Vector.<Number> = new Vector.<Number>
                Utils3D.projectVectors(worldMatrix, sphere.vertices, persVerts, sphere.uvtData)
                persVerts.map(function(item:Number, index:int, vector:Vector.<Number>):void {
                    vector[index] += (index%2==0) ? stage.stageWidth/2 : stage.stageHeight/2
                })
                with (graphics) {
                    clear()    
                    beginBitmapFill(texture)         
                    drawTriangles(persVerts, sphere.indices, sphere.uvtData, 'negative')
                }
            })                  
        }
    }    
}
