/**
 * Copyright greentec ( http://wonderfl.net/user/greentec )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qAws
 */

// forked from greentec's Circle Placement
package {
    import flash.filters.DropShadowFilter;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import com.bit101.components.Label;
//    import flash.geom.Matrix;
    
    public class CirclePlacement extends Sprite {
        public var circle:Circle;
        public var circs:Array=[];
        public var num:uint=15;
        public var H:Number=stage.stageHeight;
        public var W:Number=stage.stageWidth;
        public var _sumLabel:Label;
        public var bg_Sp:Sprite;
        public var bgData:BitmapData;
        public var bg:Bitmap;
        public var stariter:uint=300;
        
        public function CirclePlacement() {
            
            bg_Sp=new Sprite();
            addChild(bg_Sp);
            
            Draw_Space();
            
            
            addEventListener(Event.ENTER_FRAME, onAdd);
            
            _sumLabel = new Label(this, 0, 0, "Num : 0");
            _sumLabel.filters=[new DropShadowFilter(2.0, 45,0x00ff00)];
        }
        
        public function Draw_Space():void
        {
            bgData=new BitmapData(465,465,false,0);
            
            for(var i:uint=0;i<stariter;i++)
            {
                var r:uint=Math.random()*100+155;
                var g:uint=Math.random()*100+155;
                var b:uint=Math.random()*100+155;
                var cl:uint=(r<<16)|(g<<8)|b;
                bgData.setPixel(Math.random()*465,Math.random()*465,cl);    
            
            }

            
            bg=new Bitmap(bgData);
            bg_Sp.addChild(bg);
            
            
        }

        
        public function onAdd(e:Event):void
        {
            var sw:Boolean=false;
            circle=new Circle();
            circle.x=Math.random()*W;
            circle.y=Math.random()*H;
            
            
            var circ2:Circle;
            var i:int;
            if(circs.length==0)
            {
                addChild(circle);
                circs.push(circle);
            }
            else
            {
                for(i=circs.length-1;i>-1;i--)
                {
                    circ2=circs[i];    
                    if(circ2.hitTestObject(circle)==true)
                    {
                        sw=true;
                    }

                    
                }
   
                if(sw==false)
                {
                    addChild(circle);
                    circs.push(circle);
                    
                    _sumLabel.text="Num : "+circs.length;
                }
            
            }

            
            
            
            if(circs.length==num)
            {
                removeEventListener(Event.ENTER_FRAME, onAdd);
                Ship_Placement();   
                addEventListener(Event.ENTER_FRAME, wipeCircleOut);
            
            }

        }
        
        public function wipeCircleOut(e:Event):void
        {
            for(var i:int=0;i<circs.length;i++)
            {
                circs[i].alpha-=0.02;    
                if(circs[i].alpha<0)
                {
                    removeEventListener(Event.ENTER_FRAME, wipeCircleOut);
                }

            }

        }
        
        public function Ship_Placement():void
        {
            var ship:Ship;
            for(var i:int=0;i<circs.length;i++)
            {
                ship=new Ship();
                ship.x=circs[i].x;
                ship.y=circs[i].y;
                ship.rotation=Math.random()*360;
                addChild(ship);
            
            }

            
        }


    }
}



import flash.display.Sprite;
import flash.geom.Matrix;

class Circle extends Sprite
{
    public var r:Number, color:Number;
        
    public function Circle(r:Number=0, color:uint=0x333333)
    {
        var m:Matrix;
        r=Math.random()*10+35;
        
        this.graphics.lineStyle(0,0xffffff);
        this.graphics.beginGradientFill("radial",[0xffffff,0x0000ff],[0.7,0],[0,100],m=new Matrix(400,400,Math.PI/2,0,0));
        this.graphics.drawCircle(0,0,r);
        this.graphics.endFill();
        //this.blendMode="screen";
    }


}

class Ship extends Sprite
{
    public var color:Number;
    
    public function Ship(color:uint=0xffffff)
    {
        
            graphics.lineStyle(0,color);
            graphics.moveTo(8,0);
            graphics.lineTo(-8,4);
            graphics.lineTo(-8,-4);
            graphics.lineTo(8,0);
        
        

    }

}

