/**
 * Copyright miyaoka ( http://wonderfl.net/user/miyaoka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qAiy
 */

/*
 * inspired from Tanaka's friendly adventure
 * by bento_smile
 * http://forums.tigsource.com/index.php?topic=7342
 * 
 */

package 
{
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	import caurina.transitions.Tweener;
	import flash.utils.Timer;
	
	[SWF(width = "465", height = "465", backgroundColor = 0xCC9966, frameRate = "60")]
	
	public class Tanaka extends Sprite 
	{
		private var container:Sprite = new Sprite();
		private var colors:Array = [
			0xea9d97,
			0xe4e973,
			0x96a1ee,
			0xa3e090
		];
		private var colorIdx:uint = 0;
		private var timer:Timer;
		public function Tanaka() 
		{
			bgUpdate(null);
Wonderfl.capture_delay( 10 );
			
			timer = new Timer(8000);
			timer.addEventListener(TimerEvent.TIMER, bgUpdate);
			timer.start();
			
			addChild(container);
			container.y = 0;
			container.scaleX = container.scaleY = 4;
			
			
			var num:uint = 10;
			
			for (var i:uint = 0; i < num; i++)
			{
				add();
			}

		}
		private function bgUpdate(e:TimerEvent):void 
		{
			var g:Graphics = graphics;
			g.clear();
			colorIdx = (colorIdx + Math.floor((colors.length - 1) * Math.random()) +1) % colors.length;
			
			
			g.beginFill(colors[colorIdx]);
			g.drawRect(0, 0, 465, 465);
			
		}
		private function add():void 
		{
			var lr:Number = (Math.random() < 0.5) ? 1 : -1;
			var c:Creature = new Creature(lr);
			c.baseY = (stage.stageHeight / container.scaleY - c.height) * Math.random() + c.height;
			c.x = (lr > 0) ? -c.width : stage.stageWidth / container.scaleX + c.width;
			c.addEventListener(Event.COMPLETE, function() :void {
				container.removeChild(c);
				c = null;
				add() 
			} );
			
			var num:uint = container.numChildren;
			while (num--) 
			{
				var c2:Creature = container.getChildAt(num) as Creature;
				
				if (c2.baseY < c.baseY) 
				{
					container.addChildAt(c, num+1);
					return;
				}	
			}
			container.addChildAt(c, 0);
			
		}
		
	}
	
}
import flash.display.*;
import flash.events.*;
import flash.geom.*;
import caurina.transitions.Tweener;
import flash.utils.Timer;

class Creature
extends Sprite
{
	private var w:uint;
	private var h:uint;
	private var body:Body;
	private var lLeg:Leg;
	private var rLeg:Leg;
	private var lEye:Eye;
	private var rEye:Eye;
	private var timer:Timer
	private var vct:Number;
	public var baseY:Number;
	public function Creature(vct:Number):void 
	{
		this.vct = vct;
		var bodyColor:uint = (Math.random() * 0x40 + 0xC0) << 16 | (Math.random() * 0x40 + 0xC0) << 8 | Math.random() * 0x40 + 0xC0;
		var altColor:uint =  (Math.random() * 0x80) << 16 | (Math.random() * 0x80) << 8 | (Math.random() * 0x80); 

		
		var hasBorder:Boolean = Math.random() < 0.5 ? true : false;
		
		w = 1 + Math.floor(Math.random() * 10);
		h = 1 + Math.floor(Math.random() * 15);
		var centerSpan:uint = (Math.random() < 0.5) ? 1 : 2;
		
		
		//eyes
		var eyesW:uint = Math.floor(w * 0.5 * Math.random()) + 1;
		var eyesH:uint = Math.floor(h * 0.5 * Math.random()) + 1;
		
		if (w - eyesW < 1 || h - eyesH < 1) hasBorder = false; 
		
		lEye = new Eye(eyesW, eyesH, hasBorder ? altColor : bodyColor);
		rEye = new Eye(eyesW, eyesH, hasBorder ? altColor : bodyColor);
		lEye.y = rEye.y = -eyesH - Math.floor((h - eyesH + (hasBorder ? 0 : 1)) * Math.random()) + (hasBorder ? -1 : 0);
		
		var eyesX:Number = eyesW / 2 + Math.floor((w - eyesW + 1) * Math.random());
		lEye.x = -w - centerSpan / 2 + eyesX;
		rEye.x = w + centerSpan / 2 - eyesX;
		

		body = new Body(w * 2 + centerSpan, h, hasBorder ? bodyColor : altColor,  altColor);
		
		
		//legs
		var legsW:uint = Math.floor((w / 2 + 1) * Math.random()) + 1;
		var legsH:uint = Math.floor(Math.random() * 2) + 2;
		lLeg = new Leg(legsW, legsH, altColor);
		rLeg = new Leg(legsW, legsH, altColor);
		lLeg.y = rLeg.y = 1;
		var legsX:Number = legsW / 2 + Math.floor((w - legsW + 2) * Math.random());
		lLeg.x = -w -1 - centerSpan / 2 + legsX;
		rLeg.x = w + 1 + centerSpan / 2 - legsX;
		

		
		addChild(lLeg);
		addChild(rLeg);
		addChild(body);
		addChild(lEye);
		addChild(rEye);
		
		addEventListener(Event.ADDED_TO_STAGE, init);
	}
	private function init(e:Event):void 
	{
		removeEventListener(Event.ADDED_TO_STAGE, init);
		startWalk(null);
	}
	private function startWalk(e:TimerEvent):void 
	{
		walk(null);
		setY();

		timer = new Timer(50 + Math.random() * 100, 30 + Math.random()*30);
		timer.addEventListener(TimerEvent.TIMER, walk);
		timer.addEventListener(TimerEvent.TIMER_COMPLETE, startWait);
		timer.start();
		
		addEventListener(Event.ENTER_FRAME, move);
	}
	private function move(e:Event):void 
	{
		x += 20 / timer.delay * vct;
		var b:Rectangle = getBounds(root);
		
		
		if (vct > 0)
		{
			if (b.left > 465) dispatchEvent(new Event(Event.COMPLETE)); 
		}
		else if (vct < 0)
		{
			if (b.right < 0) dispatchEvent(new Event(Event.COMPLETE)); 
		}
	}
	private function walk(e:TimerEvent):void 
	{
		if (lLeg.y == 0)
		{
			lLeg.y = 1;
			rLeg.y = 0;
		}
		else
		{
			lLeg.y = 0;
			rLeg.y = 1;				
		}
	}
	private function wait(e:TimerEvent):void 
	{
		if (lLeg.y == 0)
		{
			lLeg.y = 1;
			rLeg.y = 1;
		}
		else
		{
			lLeg.y = 0;
			rLeg.y = 0;	
		}		
		setY();
	}
	private function startWait(e:TimerEvent):void 
	{
		removeEventListener(Event.ENTER_FRAME, move);
		lLeg.y = 0;
		rLeg.y = 0;
		setY();
		
		timer = new Timer(500 + Math.random() * 500, 3 + Math.random() * 4);
		timer.addEventListener(TimerEvent.TIMER, wait);
		timer.addEventListener(TimerEvent.TIMER_COMPLETE, startWalk);
		timer.start();
	}
	private function setY():void 
	{
		var b:Rectangle = getBounds(parent);
		y = baseY + y - b.bottom;	
	}
}
class Body
extends Shape
{
	public function Body(w:uint, h:uint, color:uint, borderColor:uint):void 
	{
		var g:Graphics = graphics;
		g.beginFill(borderColor);
		g.drawRect( -w / 2 - 1, -h - 1, w + 2, h + 2);
		g.endFill();
		g.beginFill(color);
		g.drawRect( -w / 2, -h, w, h);
		g.endFill();
	}
}
class Leg
extends Shape
{
	public function Leg(w:uint, h:uint, color:uint):void 
	{
		var g:Graphics = graphics;
		g.beginFill(color);
		g.drawRect( -w / 2, 0, w, h);
		g.endFill();		
	}
}
class Eye
extends Shape
{
	public function Eye(w:uint, h:uint, color:uint):void 
	{
		var g:Graphics = graphics;
		g.beginFill(color);
		g.drawRect( -w / 2, 0, w, h);
		g.endFill();		
	}
}