/**
 * Copyright yangliu9812 ( http://wonderfl.net/user/yangliu9812 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qAiv
 */

// forked from WLAD's forked from: Geometrical Hurricane
// forked from bradsedito's Geometrical Hurricane
// forked from devon_o's Circles in Circles
package {
    
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    
    /**
     * just playing around with this idea: http://i.imgur.com/F9O5s.jpg
     * @author Devon O.
     */
    [SWF(width='465', height='465', backgroundColor='#444444', frameRate='60')]
    public class Main extends Sprite {
        
        public static const NUM_CIRCLES:int = 4;
        
        private var _circles:Vector.<Sprite> = new Vector.<Sprite>(NUM_CIRCLES, true);
        private var _cholder:Sprite;
        private var _source:Sprite;
        private var _display:BitmapData;
        
        private var _blur:BlurFilter = new BlurFilter(4, 4, 3);
        private var _pt:Point = new Point();
        
        public function Main():void {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(event:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);

            _cholder = new Sprite();
            _cholder.x = stage.stageWidth >> 1;
            _cholder.y = stage.stageHeight >> 1;
            
            _source = new Sprite();
            _source.addChild(_cholder);
            
            _display = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0xFFFFFF);
            addChild(new Bitmap(_display));
            
            var r:int = 200; 
            var numItems:int = 50;
            for (var i:int = 0; i < NUM_CIRCLES; i++) {
                createCircle(numItems, r, i);
                numItems -= 12;
                r -= 45;
            }
            
            addEventListener(Event.ENTER_FRAME, turn);
        }
        
        private function createCircle(numItems:int, r:int, it:int):void {
            var c:Sprite = new Sprite();
            var angleIncrement:Number = 360 / numItems;
            for (var i:int = 0; i <= numItems; i++) {
                var s:Shape = makeSquare((i & 1) == 0 ? 0xFFFFFF : 0x000000);
                var rads:Number  = (i * angleIncrement) * Math.PI / 180;    
                var dx:Number = Math.cos(rads) * r;
                var dy:Number = Math.sin(rads) * r;
                s.rotation = Math.atan2(dy, dx) * 57.2957795;
                s.rotation += (it & 1) == 0 ? 15 : - 15;
                s.x = dx;
                s.y = dy;
                
                c.addChild(s);
                this.rotationY += rotationY;
            } 
            _circles[it] = c;
            _cholder.addChild(c);
        }
        
        private function makeSquare(color:uint):Shape {
            var s:Shape = new Shape();
            s.graphics.lineStyle(0, color);
            s.graphics.drawRect( -25, -25, 60, 60);
            return s;
        }
        
        private function turn(event:Event):void {
            var i:int = NUM_CIRCLES;
            while (i--) _circles[i].rotation += (i & 1) == 0 ? 1 : -1;

            var xr:Number = ((stage.mouseX / stage.stageWidth) - .5) * 2;
            var yr:Number = ((stage.mouseY / stage.stageHeight) - .5) * 2;
            var tx:Number = xr * 45;
            var ty:Number = yr * 45;
            _cholder.rotationY += (tx - _cholder.rotationY) / 20;
            _cholder.rotationX += ( -ty - _cholder.rotationX) / 20;
            
            _display.applyFilter(_display, _display.rect, _pt, _blur);
            _display.draw(_source);
            
        }
    }
}