/**
 * Copyright hacker_szoe51ih ( http://wonderfl.net/user/hacker_szoe51ih )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qAUQ
 */

package {
    import adobe.utils.CustomActions;
    import flash.display.*;
    import flash.events.*;
    import flash.filters.DisplacementMapFilter;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.net.*;
    import flash.system.*;
    import flash.utils.Timer;

    [SWF(width=465,height=465,backgroundColor=0xffffff,frameRate=60)]
    public class Main extends Sprite {
        
        public var objectSp:Sprite;
        public var objectSp2:Sprite;
        public var objectSp3:Sprite;
        public var ObjectBM:Bitmap;
        public var canvasBM:Bitmap;
        public var canvasBMD:BitmapData;
        public var mapBMD:BitmapData;
        public var mapBM:Bitmap;
        public var perlinNum:Number = 0;
        public var W:Number = stage.stageWidth;
        public var H:Number = stage.stageHeight;
        
        public var controlNumX:Number = 0;
        public var controlNumY:Number = 140;
        
        

        public function Main() {
            init();
        }
        
        public function init():void {
            
            var mtx:Matrix = new Matrix();
            mtx.createGradientBox(100, 100, -90 * (Math.PI / 180), 0, 0);
            
            objectSp = new Sprite();
            objectSp.graphics.beginGradientFill(GradientType.LINEAR, [0x0066cc, 0x0099ff], [1, 1], [0,  255], mtx,SpreadMethod.PAD);
            objectSp.graphics.drawRect(0, 0,W,H);
            objectSp.graphics.endFill();
            addChild(objectSp);
            objectSp.x = 0;
            objectSp.y = 220;
            
            objectSp2 = new Sprite();
            objectSp2.graphics.beginGradientFill(GradientType.LINEAR, [0x0066cc, 0x0099ff], [1, 1], [0,  255], mtx,SpreadMethod.PAD);
            objectSp2.graphics.drawRect(0, 0,W,H);
            objectSp2.graphics.endFill();
            addChild(objectSp2);
            objectSp2.alpha = 0.5;
            objectSp2.blendMode = BlendMode.MULTIPLY;
            objectSp2.x = 0;
            objectSp2.y = 240;
            
            objectSp3 = new Sprite();
            objectSp3.graphics.beginGradientFill(GradientType.LINEAR, [0x0066cc, 0x0099ff], [1, 1], [0,  255], mtx,SpreadMethod.PAD);
            objectSp3.graphics.drawRect(0, 0,W,H);
            objectSp3.graphics.endFill();
            addChild(objectSp3);
            objectSp3.alpha = 0.5;
            objectSp3.blendMode = BlendMode.MULTIPLY;
            objectSp3.x = 0;
            objectSp3.y = 220;
                        
            stage.addEventListener(Event.ENTER_FRAME,onEnterFramer);
        }
    
        public function onEnterFramer(e:Event):void {
        
            perlinNum += 10;
            var disp:DisplacementMapFilter = new DisplacementMapFilter();
            var disp2:DisplacementMapFilter = new DisplacementMapFilter();
            var disp3:DisplacementMapFilter = new DisplacementMapFilter();
            disp = displacementMap(perlinNum, perlinNum,130,180);
            disp2 = displacementMap(perlinNum, perlinNum, 180, 140);
            disp3 = displacementMap(perlinNum, perlinNum,140,110);
            objectSp.filters = [disp];
            objectSp2.filters = [disp2];
            objectSp3.filters = [disp3];
        }
        
        public function displacementMap(px:Number,py:Number,bX:Number,bY:Number):DisplacementMapFilter {
            var dis:DisplacementMapFilter = new DisplacementMapFilter();
            dis.mapBitmap = perlinMap(px, py,bX,bY);
            var po:Point = new Point(0,-200);
            dis.mapPoint = po;
            var colChannel:uint = BitmapDataChannel.RED;
            var colChannel2:uint = BitmapDataChannel.BLUE;
            dis.componentX = colChannel;
            dis.componentY = colChannel2;
            dis.scaleX = 0;
            dis.scaleY = bY;
            var modest:String = new String("color");
            dis.mode = modest;
            return dis;
        }
        
        public function perlinMap(px:Number,py:Number,bX:Number,bY:Number):BitmapData {
            var bmd:BitmapData = new BitmapData(W,H);
            var baseX:Number = bX;
            var baseY:Number = bY;
            var numOctaves:uint = 1;
            var ramdomseed:int = 10;
            var stitch:Boolean = true;
            var factalNoize:Boolean = true;
            var channelOption:uint =BitmapDataChannel.RED|BitmapDataChannel.GREEN |BitmapDataChannel.BLUE ;
            var grayScale:Boolean = false;
            var offsets:Array = [new Point(0,px),new Point(py,0)];
            bmd.perlinNoise(baseX, baseY, numOctaves, ramdomseed, stitch, factalNoize, channelOption, grayScale, offsets);
            return bmd;
        }
    
        
        

    }


}