/**
 * Copyright siny ( http://wonderfl.net/user/siny )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/q9p9
 */

package {
	import flash.events.*;
    import flash.display.Sprite;
    import org.papervision3d.scenes.Scene3D;
	import org.papervision3d.cameras.Camera3D;
	import org.papervision3d.view.Viewport3D;
	import org.papervision3d.render.BasicRenderEngine;
	import org.papervision3d.objects.primitives.Cube
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.materials.ColorMaterial;
	import org.papervision3d.materials.utils.MaterialsList;
[SWF(width=465, height=465, backgroundColor=0x000000, frameRate=30)]	
    public class FlashTest extends Sprite {
    	
    		public var scene:Scene3D;
		public var camera:Camera3D;
		public var viewport:Viewport3D;
		public var renderer:BasicRenderEngine; 
		
		public var material_fr:ColorMaterial;
		public var material_bk:ColorMaterial;
		public var material_rt:ColorMaterial;
		public var material_lt:ColorMaterial;
		public var material_top:ColorMaterial;
		public var material_btm:ColorMaterial;
		
		public var materials:MaterialsList;
		public var cube:Cube;
		
		public var do3d:DisplayObject3D = new DisplayObject3D();
    		
        public function FlashTest() {

    			scene = new Scene3D();
			camera = new Camera3D();
			camera.fov = 50;
			viewport = new Viewport3D(465, 465, true);
			addChild(viewport);
			renderer = new BasicRenderEngine();
			material_fr = new ColorMaterial( 0x999999 );
			material_bk = new ColorMaterial( 0xff0000 );
			material_rt = new ColorMaterial( 0x777777 );
			material_lt = new ColorMaterial( 0x666666 );
			material_top = new ColorMaterial( 0x555555 );
			material_btm = new ColorMaterial( 0x444444 );
			materials = new MaterialsList
			({
    		front	: material_fr,
    		back	: material_bk,
    		right	: material_rt,
    		left	: material_lt,
    		top		: material_top,
    		bottom	: material_btm
			});
			cube = new Cube( materials, 300, 300, 300 );
			do3d.addChild(cube);
			scene.addChild(do3d);
			addEventListener(Event.ENTER_FRAME, onEnterFrame, false, 0, true);
        }
        
        	public function onEnterFrame(event:Event):void {
        		
        		do3d.rotationY = mouseX/stage.stageWidth*360;
        		do3d.rotationX = -mouseY/465*360;
			
    			renderer.renderScene(scene, camera, viewport); //レンダリング処理
		}
        
    }
}