/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/q9mI
 */

package
{
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.text.TextField;
 
	public class Main extends Sprite
	{
		private var mouseOverTF:TextField;
		private var mouseOutTF:TextField;
		private var rollOverTF:TextField;
		private var rollOutTF:TextField;
 
		private var mout:int = 1;
		private var mover:int = 1;
		private var rout:int = 1;
		private var rover:int = 1;
 
		public function Main()
		{
			var rect:Sprite = new Sprite();
			rect.graphics.beginFill(0x0);
			rect.graphics.drawRect(0, 0, 200, 200);
			rect.graphics.endFill();
			addChild(rect);
 
			var circle:Sprite = new Sprite();
			circle.graphics.beginFill(0xED1A3D);
			circle.graphics.drawCircle(200, 100, 50);
			circle.graphics.endFill();
			rect.addChild(circle);
 
			rect.addEventListener(MouseEvent.MOUSE_OVER, onMouseOver);
			rect.addEventListener(MouseEvent.MOUSE_OUT, onMouseOut);
			//rect.addEventListener(MouseEvent.ROLL_OVER, onRollOver);
			//rect.addEventListener(MouseEvent.ROLL_OUT, onRollOut);
 
			mouseOverTF = Text.createTextField(250, 0);
			addChild(mouseOverTF);
 
			mouseOutTF = Text.createTextField(250, 50);
			addChild(mouseOutTF);
 
			rollOverTF = Text.createTextField(250, 100);
			addChild(rollOverTF);
 
			rollOutTF = Text.createTextField(250, 150);
			addChild(rollOutTF);
		}
 
		private function onMouseOver(event:MouseEvent):void
		{
			mouseOverTF.text = mover++ + "回目 : " + event.type;
		}
 
		private function onMouseOut(event:MouseEvent):void 
		{
			mouseOutTF.text = mout++ + "回目 : " + event.type;
		}
 
		private function onRollOver(event:MouseEvent):void 
		{
			rollOverTF.text = rover++ + "回目 : " + event.type;
		}
 
		private function onRollOut(event:MouseEvent):void
		{
			rollOutTF.text = rout++ + "回目 : " + event.type;
		}
	}
}
 
import flash.text.TextField;
import flash.text.TextFormat;
 
class Text
{
	public static function createTextField(x:int, y:int, text:String = ""):TextField
	{
		var tf:TextField = new TextField();
		tf.defaultTextFormat = new TextFormat("_typeWriter", 20, 0x0, true);
		tf.text = text;
		tf.autoSize = "left";
		tf.x = x;
		tf.y = y;
 
		return tf;
	}
}
