/**
 * Copyright wh0 ( http://wonderfl.net/user/wh0 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/q9Tb
 */

// forked from wh0's microstock theft engine
package {
    import mx.utils.Base64Decoder;
    import flash.display.*;
    import flash.events.*;
    import flash.system.*;
    import flash.filters.*;
    import flash.net.*;
    import flash.text.*;
    import flash.ui.*;
    
    import com.actionscriptbible.Example;
    [SWF(backgroundColor=0x808080)]
    public class MSTE extends Example {
        
        private static const CONTEXT:LoaderContext = new LoaderContext(true);
        private static const DIM:int = 380;
        
        private var qty:int = 0;
        private var src:Loader;
        private var sf:ShaderFilter;
        
        public function MSTE() {
            loaderInfo.uncaughtErrorEvents.addEventListener(UncaughtErrorEvent.UNCAUGHT_ERROR, function(e:UncaughtErrorEvent):void { trace(e.error); });
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            src = new Loader();
            addChild(src);
            src.contentLoaderInfo.addEventListener(Event.COMPLETE, srcGet);
            
            var ll:Loader = new Loader();
            ll.contentLoaderInfo.addEventListener(Event.COMPLETE, loGet);
            ll.load(new URLRequest('http://assets.wonderfl.net/images/related_images/3/39/394f/394fabc32e98f37e9bff6dd9c3b1b9074da0d8a4'), CONTEXT);
            
            var hl:Loader = new Loader();
            hl.contentLoaderInfo.addEventListener(Event.COMPLETE, hiGet);
            hl.load(new URLRequest('http://assets.wonderfl.net/images/related_images/9/95/9546/9546e0e0f3819ef545b445b3fd23768a510315a9'), CONTEXT);
            
            // see bottom for shader source
            var d:Base64Decoder = new Base64Decoder();
            d.decode('oQECAAAMX091dENvb3JkAKEBAgQADGQAowAEc3JjAKMBBGxvAKMCBGhpAKECBAEAD2RzdAAdBQDBAAAQAAIFAMEEABAAMAEA8QAAEAAwAgDxBQAQATADAPEFABACAgEA4gIAGAACAwDiAgAYAAUBAOIDABgA');
            sf = new ShaderFilter(new Shader(d.toByteArray()));
            sf.shader.data.d.value = [0, 0];
            
            var tf:TextField = new TextField();
            tf.type = TextFieldType.INPUT;
            stage.focus = tf;
            tf.addEventListener(TextEvent.TEXT_INPUT, onTextInput);
            tf.addEventListener(FocusEvent.FOCUS_OUT, onFocusOut);
            tf.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
        }
        
        private function onFocusOut(e:FocusEvent):void {
            stage.focus = e.target as TextField;
        }
        
        private function onTextInput(e:TextEvent):void {
            (e.target as TextField).text = '';
            if (e.text.length > 1) src.load(new URLRequest(e.text));
        }
        
        private function srcGet(e:Event=null):void {
            src.x = (stage.stageWidth - src.width) / 2;
            src.y = (stage.stageHeight - src.height) / 2;
            center();
        }
        
        private function loGet(e:Event):void {
            sf.shader.data.lo.input = e.target.content.bitmapData;
            qty++;
            apply();
        }
        
        private function hiGet(e:Event):void {
            sf.shader.data.hi.input = e.target.content.bitmapData;
            qty++;
            apply();
        }
        
        private function center():void {
            sf.shader.data.d.value[0] = Math.floor((src.width - DIM) / 2) + 1;
            sf.shader.data.d.value[1] = Math.floor((src.height - DIM) / 2) + 1;
            apply();
        }
        
        private function apply():void {
            if (qty < 2) return;
            src.filters = [sf];
        }
        
        private function onKeyDown(e:KeyboardEvent):void {
            var delta:int = e.ctrlKey ? 10 : 1;
            switch (e.keyCode) {
                case Keyboard.UP:
                    sf.shader.data.d.value[1] -= delta; apply(); break;
                case Keyboard.DOWN:
                    sf.shader.data.d.value[1] += delta; apply(); break;
                case Keyboard.LEFT:
                    sf.shader.data.d.value[0] -= delta; apply(); break;
                case Keyboard.RIGHT:
                    sf.shader.data.d.value[0] += delta; apply(); break;
                case Keyboard.HOME:
                    center(); break;
            }
        }

        
    }
}

/**
parameter "_OutCoord", float2, f0.rg, in
parameter "d", float2, f4.rg, in
texture  "src", t0
texture  "lo", t1
texture  "hi", t2
parameter "dst", float4, f1, out

sub f0.rg, f4.rg

texn f1, f0.rg, t0
texn f2, f0.rg, t1
texn f3, f0.rg, t2

sub f1.rgb, f2.rgb
sub f3.rgb, f2.rgb
div f1.rgb, f3.rgb
*/