/**
 * Copyright 3f5 ( http://wonderfl.net/user/3f5 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/q90Z
 */

package {
    import flash.display.CapsStyle;
    import flash.display.JointStyle;
    import flash.display.AVM1Movie;
    import flash.events.TimerEvent;
    import flash.text.TextLineMetrics;
    import flash.utils.Timer;
    import flash.text.TextFormat;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.text.TextField;
    import flash.display.Sprite;
    public class Edge extends Sprite {
        public function Edge() {
            var textFormat:TextFormat = new TextFormat();
            textFormat.size = 60;
            var text:TextField = new TextField();
            text.text = 'あ';
            text.autoSize = 'left';
            text.setTextFormat(textFormat);
            
            var bitmap:BitmapData = new BitmapData(text.width, text.height);
            bitmap.draw(text);
            
            var sprite:Sprite = new Sprite();
            sprite.graphics.lineStyle(1, 0xFF0000);
            
            var currentColor:uint = 0xFFFFFF, x:int = 0 , y:int = 0, _x:int, _y:int, hit:Boolean, i:int, map:Object = {}, c:Array, r:Array;
            
            stage.addChild(text);
            stage.addChild(sprite);
            
            var p:Array = [
                [1, 0],
                [0, -1],
                [-1, 0],
                [1, 1],
                [0, 1],
                [-1, -1],
                [-1, 1],
                [1, -1]
            ];
            
            for (_x = 0; _x < bitmap.width; _x++) {
                map[_x] = {};
                for (_y = 0; _y < bitmap.height; _y++) {
                    map[_x][_y] = true;
                }
            }
            
            var f:Boolean = false;
            
            (function ():void {
                hit = false;

                for (i = 0; i < p.length; i++) {
                    _x = x + p[i][0];
                    _y = y + p[i][1];
                    
                    if (map.hasOwnProperty(_x) && map[_x].hasOwnProperty(_y) && map[_x][_y] == true) {
                        if (compColor(bitmap.getPixel(_x,  _y), currentColor)) {
                            x = _x;
                            y = _y;
                            hit = true;
                            text.text = text.text + (i.toString());
                            break;
                        }
                        else {
                            map[_x][_y] = false;
                        }

                    }
                }
                
                if (!hit) {
                    f = true;
                    for (_x = 0; _x < bitmap.width; _x++) {
                        for (_y = 0; _y < bitmap.height; _y++) {
                            if (map[_x] && map[_x][_y] == true) {
                                x = _x;
                                y = _y;
                                hit = true;
                                break;
                            }
                        }
                    }
                    if (!hit) return;
                }

                map[x][y] = false;
                    if (f) {
                        sprite.graphics.moveTo(x, y);
                        f = false;
                    }
                    sprite.graphics.lineTo(x, y);
                sleep(5, arguments.callee);
            })();
        }
        
        private function sleep(delay:int, callback:Function):void {
            var timer:Timer = new Timer(delay, 1);
            timer.addEventListener(TimerEvent.TIMER_COMPLETE, callback);
            timer.start();
        }

        private function compColor(col1:Number, col2:Number):Boolean {
            if (col1 === 0 || col2 === 0) return false;
            
            var r1:int = (col1 >> 16) & 0xFF;
            var g1:int = (col1 >>  8) & 0xFF;
            var b1:int = (col1 >>  0) & 0xFF;
            
            var r2:int = (col2 >> 16) & 0xFF;
            var g2:int = (col2 >>  8) & 0xFF;
            var b2:int = (col2 >>  0) & 0xFF;
            
            if (Math.abs(r1 - r2) <= 20 && Math.abs(g1 - g2) <= 20 && Math.abs(b1 - b2) <= 20) {
                return true;
            }
            else {
                return false;
            }


        }

    }
}