/**
 * Copyright Scmiz ( http://wonderfl.net/user/Scmiz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/q7hZ
 */

package {
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            var recipe:Recipe = new Recipe();
            recipe.width = 16;
            recipe.height = 16;
            recipe.scale = 8.0;
            recipe.data.push(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0);
            recipe.data.push(0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0);
            recipe.data.push(0, 0, 0, 0, 2, 2, 2, 3, 3, 2, 3, 0, 0, 0, 0, 0);
            recipe.data.push(0, 0, 0, 2, 3, 2, 3, 3, 3, 2, 3, 3, 3, 0, 0, 0);
            recipe.data.push(0, 0, 0, 2, 3, 2, 2, 3, 3, 3, 2, 3, 3, 3, 0, 0);
            recipe.data.push(0, 0, 0, 2, 2, 3, 3, 3, 3, 2, 2, 2, 2, 0, 0, 0);
            recipe.data.push(0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0);
            recipe.data.push(0, 0, 0, 0, 2, 2, 1, 2, 2, 2, 0, 0, 0, 0, 0, 0);
            recipe.data.push(0, 0, 0, 2, 2, 2, 1, 2, 2, 1, 2, 2, 2, 0, 0, 0);
            recipe.data.push(0, 0, 2, 2, 2, 2, 1, 1, 1, 1, 2, 2, 2, 2, 0, 0);
            recipe.data.push(0, 0, 3, 3, 2, 1, 3, 1, 1, 3, 1, 2, 3, 3, 0, 0);
            recipe.data.push(0, 0, 3, 3, 3, 1, 1, 1, 1, 1, 1, 3, 3, 3, 0, 0);
            recipe.data.push(0, 0, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 0, 0);
            recipe.data.push(0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0);
            recipe.data.push(0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 2, 2, 2, 0, 0, 0);
            recipe.data.push(0, 0, 2, 2, 2, 2, 0, 0, 0, 0, 2, 2, 2, 2, 0, 0);
            recipe.pallet.push(0x000000, 0xbd3939, 0x7b7b00, 0xde9c39);
            recipe.transparent = 0;
            
            var d:DotDraw = new DotDraw(recipe);
            d.x = 232.5 - (8 * 8);
            d.y = 232.5 - (8 * 8);
            this.addChild(d);
        }
    }
}
import flash.display.Sprite;

class Recipe
{
    public var width:uint = 0;
    public var height:uint = 0;
    public var scale:Number = 1.0;
    public var data:/*uint*/Array = new Array();
    public var pallet:/*uint*/Array = new Array();
    public var transparent:int = -1;
}

class DotDraw extends Sprite
{
    public function DotDraw(recipe:Recipe) {
        for (var index:uint = 0; index < recipe.width * recipe.height; ++index) {
            var x:uint = index % recipe.width;
            var y:uint = uint(index / recipe.width);
            
            var datum:uint = recipe.data[x + (y * recipe.width)];
            var color:uint = recipe.pallet[datum];
            var scale:Number = recipe.scale;
            var alpha:Number = (datum == recipe.transparent) ? 0.0 : 1.0;
            
            this.graphics.beginFill(color, alpha);
            this.graphics.drawRect(x * scale, y * scale, scale, scale);
            this.graphics.endFill();
        }
    }

}
