/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/q7ES
 */

package
{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.net.*;
    
    [SWF(frameRate = 60, width = 400, height = 300)]
    public class Main extends Sprite
    {
        public var collisionArray :Array = new Array;

        public function Main()
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            _init();
        }
        
        public function _init() :void
        {
            addChild(collisionArray[0] = new PhysObject(40, 30));
            addChild(collisionArray[1] = new PhysObject(140, 30));
            addChild(collisionArray[2] = new PhysObject(240, 30));
            
            graphics.clear     ();
            graphics.lineStyle (1, 0, 0.75);
            graphics.drawRect  (0, 0, 399, 299); 
        }
    }
}

import flash.display.*;
import flash.events.*;
import flash.geom.*;
import flash.net.*;

class PhysObject extends Sprite
{
    protected var _x :Number;
    protected var _y :Number;
    protected var _w :Number;
    protected var _h :Number;
    protected var _a :Number;
    protected var _c :Number;
    
    internal var firstPoint   :Point = new Point;
    internal var currentPoint :Point = new Point;
    internal var calcPoint    :Point = new Point;
    
    public function PhysObject($x:Number, $y:Number, $w:Number = 50, $h:Number = 50, $a:Number = 0.5, $c:Number = 0)
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);

        _x = $x;
        _y = $y;
        _w = $w;
        _h = $h;
        _a = $a;
        _c = $c;
    }
    
    public function _init() :void
    {     
        graphics.clear     ();
        graphics.beginFill (0, _a);
        graphics.lineStyle (1, _c, _a + 0.25);
        graphics.drawRect  (_x, _y, _w, _h);
        graphics.endFill   ();
    }
    
    public function collision($array:Array) :Object
    {
        var stageX        :Number = 0;
        var stageY        :Number = 0;
        var stageWidth    :Number = 400;
        var stageHeight   :Number = 300;
        var lineThickness :Number = 1;
        
        //legacy container collision
        
        if  ( x < 0 )
            { x = (x - (x - (stageX))) }
            
        if  ( y < 0 )
            { y = (y - (y - (stageY))) }
        
        if  ((y + height + lineThickness) > stageHeight )
            { y = (y - (y - (stageHeight - (height + lineThickness)))) }
            
        if  ((x + width + lineThickness) > stageWidth )
            { x = (x - (x - (stageWidth - (width + lineThickness)))) }
            
        //check object against collision array
        //exclude self

        return null;
    }

    public function addedToStage($e:Event) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
        addEventListener(Event.ENTER_FRAME, onEnterFrame);
        
        _init();
    }
    
    public function onMouseDown($e:MouseEvent) :void
    {
        stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);

        firstPoint = new Point($e.stageX, $e.stageY);
            
        stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
    }
        
    public function onMouseMove($e:MouseEvent) :void
    {
        currentPoint = new Point($e.stageX, $e.stageY);
        calcPoint = Point(currentPoint.subtract(firstPoint));
            
        x = (x + calcPoint.x);
        y = (y + calcPoint.y);
        
        firstPoint = currentPoint;
    }
        
    public function onMouseUp($e:MouseEvent) :void
    {
        stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
        stage.removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
    }
    
    public function onEnterFrame($e:Event) :void
    {
        y ++;
        
        collision(null);
    }
    
    public override function get x() :Number
    { return _x }
    
    public override function get y() :Number
    { return _y }
    
    public override function get width() :Number
    { return _w }
    
    public override function get height() :Number
    { return _h }
    
    public override function get alpha() :Number
    { return _a }
    
    public function get color() :Number
    { return _c }
    
    public override function set x($value:Number) :void
    {
        _x = $value;
        _init();
    }
    
    public override function set y($value:Number) :void
    {
        _y = $value;
        _init();
    }
    
    public override function set width($value:Number) :void
    {
        _w = $value;
        _init();
    }
    
    public override function set height($value:Number) :void
    {
        _h = $value;
        _init();
    }
    
    public override function set alpha($value:Number) :void
    {
        _a = $value;
        _init();
    }
    
    public function set color($value:Number) :void
    {
        _c = $value;
        _init();
    }
}
