/**
 * Copyright DRAMBA ( http://wonderfl.net/user/DRAMBA )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/q6nW
 */

package {
    import flash.text.TextField;
    import flash.display.MovieClip;
    import flash.events.Event;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.objects.primitives.Sphere;
    import org.papervision3d.materials.WireframeMaterial;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.core.geom.Vertices3D;
    import org.papervision3d.core.geom.renderables.Vertex3D
    import gs.TweenMax;
    import gs.easing.Quad;
    import org.papervision3d.view.layer.ViewportLayer;
    import flash.display.Sprite;    
    
    public class SphereDistribution extends BasicView 
    {
        private var mainSphere:Sphere;
        private var main:DisplayObject3D;
        private var _arVertices:Array;
        private var _arPlanes:Array;
        private var _arPositions:Array;
        private var txtLoading:TextField;
        
        public function SphereDistribution()
        {
            super();
            viewport.interactive = true;
            
            main = new DisplayObject3D();
            scene.addChild(main);
            
            txtLoading = new TextField();
            addChild(txtLoading);
            txtLoading.text = "Loading...";
            txtLoading.x = stage.stageWidth * .5;
            txtLoading.y = stage.stageHeight * .5;
            
            TweenMax.delayedCall(1,hideTxtLoading);
            
            
            camera.z = -100;
            
            createSphere();
            createPositions();
            createPlanes();
            distributePlanes();
            
            startRendering();
        }
        
        private function distributePlanes():void
        {
                        
            for (var i:int = 0; i < _arVertices.length; i++) 
            {              
                TweenMax.to(_arPlanes[i].plane, 1.5, { x:_arPositions[i].x, z:_arPositions[i].z, y:_arPositions[i].y, ease:Quad.easeIn, delay:(0.25 * i)/5 });
                TweenMax.to(_arPlanes[i].layer, 1.5, { alpha:1,delay:(0.25 * i)/5, ease:Quad.easeIn});
            }
        }
        
        private function hideTxtLoading():void
        {
            txtLoading.visible = false;
        }

        
        private function createPlanes():void
        {
            var currentLine:int = 0;
            var currentCol:int = 0;
            _arPlanes = new Array();
            _arPositions = new Array();
            
            for (var i:int = 0; i < _arVertices.length; i++) 
            {
                var colorMaterial:ColorMaterial = new ColorMaterial(Math.random() * 0xFFFFFF);
                colorMaterial.doubleSided = true;
                var plane:Plane = new Plane(colorMaterial, 30, 30, 1, 1);
                
                plane.x = _arVertices[i].x;
                plane.z = _arVertices[i].z;
                plane.y = _arVertices[i].y;
                plane.lookAt(mainSphere);
                _arPositions.push( { x:plane.x, y:plane.y, z:plane.z, rotationX:plane.rotationX, rotationY:plane.rotationY } )
                
                plane.x = -400 + (40 * currentCol);
                plane.y = 200 + (40 * -currentLine);
                plane.z = -2000;
                var viewportLayer:ViewportLayer = viewport.getChildLayer(plane);
                viewportLayer.alpha = 0;
                _arPlanes.push({plane:plane, layer:viewportLayer});
                
                currentCol++
                
                if (currentCol > 20)
                {
                    currentCol = 0;
                    currentLine++
                }
                
                main.addChild(plane);
            }
        }
        
        private function createPositions():void
        {
            _arVertices = new Array();
            for each (var vertex3d:Vertex3D in mainSphere.geometry.vertices) 
            {
                _arVertices.push(vertex3d);
            }
        }
        
        private function createSphere():void
        {
            var sphereMaterial:WireframeMaterial = new WireframeMaterial(0x333333, 0,1);
            mainSphere = new Sphere(sphereMaterial, 200,20,10);
            main.addChild(mainSphere);
        }
        
        override protected function onRenderTick(event:Event = null):void 
        {
            main.yaw(1);
            super.onRenderTick(event);
            
            var rotY:Number = (mouseY - (stage.stageHeight / 2)) / (stage.height / 2)  * 400;
            var rotX: Number = (mouseX - (stage.stageWidth / 2)) / (stage.width / 2)  * -400;
            
            camera.x -= (rotX + camera.x) /  10;
            camera.y -= (rotY + camera.y) /  10;
        }
    }
}