/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/q6Un
 */

package  {
    import Box2D.Collision.Shapes.*;
    import Box2D.Collision.b2AABB;
    import Box2D.Common.Math.b2Vec2;
    import Box2D.Dynamics.*;
    
    import Box2D.Dynamics.*
    import flash.display.*;
    import flash.events.*;
    
    /**
     * 床の上に箱を落とすFlash
     */
    [SWF(width="465", height="465", frameRate="30", backgroundColor="0x000000")]
    public class DropBox extends Sprite {
        private var world:b2World;
        
        //エントリ
        public function DropBox():void {
            // イベントハンドラを登録する
            stage.addEventListener(MouseEvent.CLICK, clickHandler);
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }
        
        private function clickHandler(event:MouseEvent):void {
            ////////////////////////////////////////
            // 物理エンジンのセットアップ
            
            // 外枠を定義する
            var worldAABB:b2AABB = new b2AABB();
            worldAABB.lowerBound.Set(-100, -100);
            worldAABB.upperBound.Set(100, 100);
            
            // 重力を下方向に10m/s^2とする
            var gravity:b2Vec2 = new b2Vec2(0, 10);
            
            // 外枠と重力を指定して、物理エンジン全体をセットアップする
            world = new b2World(worldAABB, gravity, true);
            
            ////////////////////////////////////////
            // 床の設置
            // 床は画面の下のほうに設置します
            
            // 床の位置を左から2.5m、上から3mとする
            var floorBodyDef:b2BodyDef = new b2BodyDef();
            floorBodyDef.position.Set(2.5, 3);
            
            // 床の形を、幅4m、厚さ20cmとする
            // 指定するのはその半分の値
            var floorShapeDef:b2PolygonDef = new b2PolygonDef();
            floorShapeDef.SetAsBox(2, 0.1);
            
            // 床を動かない物体として作る
            var floor:b2Body = world.CreateBody(floorBodyDef);
            floor.CreateShape(floorShapeDef);

//----------------------------
            //位置データ
            var floorBodyDef2:b2BodyDef = new b2BodyDef();
            floorBodyDef2.position.Set(3,4);
            //形状データ
            var floorShapeDef2:b2PolygonDef = new b2PolygonDef();
            floorShapeDef2.SetAsBox(0.1, 10);
            //配置
            var floor2:b2Body = world.CreateBody(floorBodyDef2);
            //floor2.CreateShape(floorShapeDef2);
 //---------------------------           
            ////////////////////////////////////////
            // 箱の設置
            // 箱は床の上から落として、少しはねるようにします
            
            // 箱の位置
            var boxBodyDef:b2BodyDef = new b2BodyDef();
            boxBodyDef.position.Set(mouseX/100,mouseY/100);
            
            // 箱の形状
            var boxShapeDef:b2PolygonDef= new b2PolygonDef();
            boxShapeDef.SetAsOrientedBox(0.3, 0.2, new b2Vec2(0, 0), 0.0);
            boxShapeDef.density = 1;        // 密度 [kg/m^2]
            boxShapeDef.restitution = 0.2;  // 反発係数、通常は0～1
            
            // 箱を動く物体として作る
            var boxBody:b2Body = world.CreateBody(boxBodyDef);
            boxBody.CreateShape(boxShapeDef);
            boxBody.SetMassFromShapes();
            
            ////////////////////////////////////////
            // 描画設定
            
            var debugDraw:b2DebugDraw = new b2DebugDraw();
            debugDraw.m_sprite = this;
            debugDraw.m_drawScale = 100; // 1mを100ピクセルにする
            debugDraw.m_fillAlpha = 0.2; // 不透明度
            debugDraw.m_lineThickness = 1; // 線の太さ
            debugDraw.m_drawFlags = b2DebugDraw.e_shapeBit;
            world.SetDebugDraw(debugDraw);
        }
        
        private function enterFrameHandler(event:Event):void {
            if (world == null) {
                return;
            }
            // Flashはデフォルトで秒間24フレームなので、
            // 物理シミュレーションを1/24秒進める
            world.Step(1 / 24, 10);
        }
    }
}