/**
 * Copyright djakarta_trap ( http://wonderfl.net/user/djakarta_trap )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/q6EF
 */

// forked from Hakuhin's テクスチャのタイリング描画
// -------------------------------------------------
//
// テクスチャをタイリング描画
// 
//　たまに動作しないので何度かリロードしてみてください。
//　
// -------------------------------------------------
package {
	import flash.events.*;
	import flash.display.*;
	import flash.net.*;
	import flash.text.*;
	import flash.utils.*;
	import flash.system.*;
	import flash.geom.*;

	public class Main extends Sprite {
		public function Main() {


// -------------------------------------------------
// コンストラクタ
// -------------------------------------------------

// 100%表示
stage.scaleMode = StageScaleMode.NO_SCALE;

// 左上
stage.align = StageAlign.TOP_LEFT;
stage.align = "TL";


var bmp_src : BitmapData = null;		// ソース用ビットマップ
var bmp_render : BitmapData = null;	// 出力用ビットマップ

// リソース読み込み開始
load();


// -------------------------------------------------
// 読み込み
// -------------------------------------------------
function load():void{

	// 画像のURL
	var graphic_url:String = "http://actionscript.web.officelive.com/wonderfl/meme.png";

	// ローダー
	var loader_obj : Loader = new Loader();

	// 読み込み開始
	var url : URLRequest = new URLRequest(graphic_url);
	loader_obj.load(url);

	// 読み込み完了時
	var info : LoaderInfo = loader_obj.contentLoaderInfo;
	info.addEventListener (Event.INIT,LoaderInfoInitFunc);
	function LoaderInfoInitFunc (event : Event):void {

		// メモリからインスタンス化
		var loader_memory : Loader = new Loader();
		loader_memory.contentLoaderInfo.addEventListener (Event.COMPLETE,LoaderInfoCompleteFunc);
		function LoaderInfoCompleteFunc (event : Event):void {

			// 画像をビットマップにキャプチャ
			addChild(loader_memory);
			bmp_src = new BitmapData( loader_memory.width , loader_memory.height , true , 0);
			bmp_src.draw(stage);
			removeChild(loader_memory);
			
			// 初期化へ
			init();

		}
		
		// 読み込み開始
		loader_memory.loadBytes(loader_obj.contentLoaderInfo.bytes);

	}

}


// -------------------------------------------------
// 初期化
// -------------------------------------------------
function init():void{

	// ステージサイズ
	var w:uint = stage.stageWidth;
	var h:uint = stage.stageHeight;   
	var w_half:Number = w/2;
	var h_half:Number = h/2;


	// -------------------------------------------------
	// 背面処理
	// -------------------------------------------------
	var sprite_back:Sprite = new Sprite();
	addChild(sprite_back);
	
	var num:int = 1;
	var i:int;
	for(i=0;i<num;i++){
		SpriteCreate();
	}
	
	function SpriteCreate():void{
		var mc:Sprite = new Sprite();
		mc.graphics.beginFill(0xff0000);
		mc.graphics.drawRect(stage.stageWidth*0.5, stage.stageHeight*0.5, 10,10);
		mc.graphics.endFill();
		sprite_back.addChild(mc);

		var bmp:Bitmap	
		bmp = new Bitmap(bmp_src);
		mc.addChild(bmp);
		bmp.x = 0;	bmp.y = 0;
		
		bmp = new Bitmap(bmp_src);
		mc.addChild(bmp);
		bmp.x = w;	bmp.y = 0;
		
		bmp = new Bitmap(bmp_src);
		mc.addChild(bmp);
		bmp.x = 0;	bmp.y = h;
	
		bmp = new Bitmap(bmp_src);
		mc.addChild(bmp);
		bmp.x = w;	bmp.y = h;

		mc.x = Math.random() * w;
		mc.y = Math.random() * h;
		
		var dx:Number = Math.random() * 2 - 1;
		var dy:Number = Math.random() * 2 - 1;
		dx *= 5;
		dy *= 5;

		addEventListener(Event.ENTER_FRAME,function():void{
			
			mc.x += dx;
			mc.y += dy;
			
			if(mc.x < -w_half)		mc.x += w;
			if(mc.y < -h_half)		mc.y += h;
			if(mc.x > w_half)		mc.x -= w;
			if(mc.y > h_half)		mc.y -= h;
		});

	}



	// -------------------------------------------------
	// 前面処理
	// -------------------------------------------------

	// 前面レイヤー
	var sprite_front:Sprite = new Sprite();
	sprite_front.visible = false;
	addChild(sprite_front);
		
	// パラメータ
	var rot:Number = -20;	// 角度
	var scale:Number = 10;	// 拡大率
	var mtx:Matrix = new Matrix(1,0,0,1,0,0);	// 描画時のの姿勢

	var mtx_ide:Matrix = new Matrix(1,0,0,1,0,0);		// 行列
	var rect:Rectangle = new Rectangle(0,0,w,h);		// ソース矩形範囲
	var color:ColorTransform = new ColorTransform(1,1,1,1,0,0,0,0);	// ソースカラー
	
	sprite_front.addEventListener(Event.ENTER_FRAME,function():void{
		// 背面レイヤーをビットマップにキャプチャ
		bmp_render = new BitmapData(w,h,true,0xFFFFFFFF);		
		bmp_render.draw(sprite_back,mtx_ide,color,BlendMode.NORMAL,rect);
		
		// 姿勢を回転しつつ縮小する
		rot += 0.05;
		scale *= 0.995;

		// 行列作成
		mtx.identity();
		mtx.translate(-w/2,-h/2);
		mtx.scale(scale,scale);
		mtx.rotate(rot*Math.PI / 180);
		mtx.translate(w/2,h/2);
		
		// テクスチャをタイリング描画
		var g:Graphics = sprite_front.graphics;
		g.clear();
		g.beginBitmapFill ( bmp_render , mtx , true , true );
		g.drawRect ( 0 , 0 , w , h );
		g.endFill();
	});

}



		}
	}
}