/**
 * Copyright christian ( http://wonderfl.net/user/christian )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/q5j3
 */

package
{
    /*
    MP3 FILE ENCODED TO PNG USING
       http://wonderfl.net/c/mEon
       SOUND 12'' IMAGE 196,86 Ko
    */

    import flash.media.*;
    import flash.events.*;
    import flash.display.*;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;

    import org.si.utils.ByteArrayExt;

    /**  @author SPANVEGA // CHRISTIAN  **/

    [SWF(backgroundColor = '0xFFFFFF', width = '465', height = '465', frameRate = '25')]

    public class PNG_MP3 extends Sprite
    {
        private var URL : String = 'http://assets.wonderfl.net/images/related_images/a/a9/a946/a946dfc70b0a956200fcd0ba420975657d85b4cc';

        private var W : uint = stage.stageWidth, H : uint = stage.stageHeight;

        private var baext : ByteArrayExt = new ByteArrayExt ();
        private var sound : Sound, channel : SoundChannel;
        private var value : Number;


        public function PNG_MP3 ()
        {
            Wonderfl.disable_capture ();

            var loader : Loader = new Loader ();
            loader.load (new URLRequest (URL), new LoaderContext (true));
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, complete);
        }

        private function complete (e : Event) : void
        {
            baext.fromBitmapData (Bitmap (e.target.content).bitmapData);

            sound = new Sound ();
            sound.loadCompressedDataFromByteArray (baext, baext.length);

            channel = sound.play (0, 1000, channels (1, 1, 1, 1));
            
            stage.addEventListener (Event.ENTER_FRAME, frame);
        }

        private function frame (e : Event) : void
        {
            SoundMixer.computeSpectrum (baext, false, 0);

            //

            graphics.clear ();
            graphics.lineStyle (1, 0x333333);

            for (var i : int = 0; i < 256; i+= 2)
            {
                value = baext.readFloat () * 200;

                graphics.moveTo (i * 1.85, W/2);
                graphics.lineTo (i * 1.85, W/2 -value);

                baext.position += 4;
            }
        }

        private function channels (LTL : Number = 1, LTR : Number = 0, RTR : Number = 1, RTL : Number = 0) : SoundTransform
        {
            var transform : SoundTransform = new SoundTransform ();

            transform.leftToLeft   = LTL;
            transform.leftToRight  = LTR;
            transform.rightToRight = RTR;
            transform.rightToLeft  = RTL;

            return transform;
        }
    }
}