/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/q5i0
 */

package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.media.Sound;
	import flash.media.SoundChannel;
	import flash.net.URLRequest;
	import flash.text.TextField;
	import flash.text.TextFormat;
	
	public class Main extends Sprite
	{
		private var sound:Sound;
		private var channel:SoundChannel;
		private var time:int;
		private var tf:TextField;
		
		public function Main()
		{
			tf = new TextField();
			tf.defaultTextFormat = new TextFormat("_typeWriter", 20, 0x0, true);
			tf.autoSize = "left";
			addChild(tf);
			
			sound = new Sound(new URLRequest("http://www19.atpages.jp/aswiki/m1.ttt"));
			channel = sound.play();
			
			stage.addEventListener(MouseEvent.CLICK, onMouseClick);
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		
		private function onEnterFrame(event:Event):void 
		{
			if (channel)
			{
				tf.text = String(Number(channel.position / 1000).toFixed(2));
			}
		}
		
		private function onMouseClick(event:MouseEvent):void 
		{
			if (channel)
			{
				time = channel.position;
				channel.stop();
				channel = null;
			}
			else
			{
				channel = sound.play(time);
			}
		}
	}
}