/**
 * Copyright mtok ( http://wonderfl.net/user/mtok )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/q5LQ
 */

// forked from checkmate's adobe challenge 2
/**
 * 
 * "Use Flash Player 10 text libraries (FTE).
 *  You can do a lot of interesting things with text,
 *  but I think it has even more potential
 *  in experimental work where
 *  the APIs are used just as a container format
 *  for images, movie clips
 *  and other interactive elements."
 *                     by Justin Everett-Church
 * 
 * This code is an example of FTE.
 */
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.DisplayObject;
    import flash.display.Loader;
    import flash.display.LoaderInfo;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.net.URLRequest;
    
    import flash.text.engine.*;
    
    public class AdobeFTE extends Sprite {
        
        private var TEXT:String = "Use Flash Player 10 text libraries (FTE).  You can do a lot of interesting things with text, but I think it has even more potential in experimental work where the APIs are used just as a container format for images, movie clips and other interactive elements.";

        public function AdobeFTE() {
            setup();
        }
        
        private function setup():void {
            // FontDescription : フォント設定
            var fontDescription:FontDescription = createFontDescription();
            
            // ElementFormat 
            var elementFormat:ElementFormat = createElementFormat( fontDescription );

            //  ContentElement
            var contentElement: ContentElement = createContentElement( TEXT, elementFormat );
            
            // TextJustifier
            var textJustifier:TextJustifier =createTextJustifier();
            
            //  TextBlock
            var textBlock:TextBlock = createTextBlock( contentElement, textJustifier );
            
            layout( textBlock );
        }
        
        private function layout(textBlock:TextBlock):void{
            var offsetX:int = 32;            
            var offsetY:int = 32;
            var lineHeight:Number=2;
            var textLine:TextLine = textBlock.createTextLine ( null, 400 );
            while (textLine) {
                addChild(textLine);
                textLine.x = offsetX;
                offsetY+= textLine.textHeight * lineHeight;
                textLine.y = offsetY;
                textLine = textBlock.createTextLine( textLine, 400 );
            }
        }
        
        
        // FontDescription : フォント設定
        private function createFontDescription():FontDescription {
            var fontDescription :FontDescription = new FontDescription();
            // CFFHinting.NONE, // CFFHinting.HORIZONTAL_STEM
            fontDescription.cffHinting = CFFHinting.HORIZONTAL_STEM;
            // FontLookup.DEVICE, FontLookup.EMBEDDED_CFF
            fontDescription.fontLookup = FontLookup.DEVICE;
            //_ゴシック, 明朝, _等幅, _sans, _serif, _typewriter
            fontDescription.fontName = "_ゴシック, _sans";
            // FontPosture.NORMAL, FontPosture.ITALIC
            fontDescription.fontPosture = FontPosture.NORMAL;
            // FontWeight.NORMAL, FontWeight.BOLD
            fontDescription.fontWeight = FontWeight.NORMAL;
            // true, false
            fontDescription.locked = false;
            // RenderingMode.NORMAL, RenderingMode.CFF
            fontDescription.renderingMode = RenderingMode.CFF;
            return fontDescription;
        }
        
        
        // ElementFormat : テキストフォーマット設定
        private function createElementFormat( fontDescription:FontDescription  ):ElementFormat {
            var elementFormat:ElementFormat = new ElementFormat();
            // TextBaseline.ROMAN, TextBaseline.ASCENT, TextBaseline.DESCENT, TextBaseline.IDEOGRAPHIC_TOP, TextBaseline.IDEOGRAPHIC_CENTER, TextBaseline.IDEOGRAPHIC_BOTTOM
            elementFormat.alignmentBaseline = TextBaseline.ROMAN;
            // Number
            elementFormat.alpha = 1;
            // Number
            elementFormat.baselineShift = 0;
            // BreakOpportunity.AUTO, BreakOpportunity.ANY, BreakOpportunity.NONE, BreakOpportunity.ALL
            elementFormat.breakOpportunity = BreakOpportunity.AUTO;
            // uint
            elementFormat.color = 0xFE0000;
            // DigitCase.DEFAULT, DigitCase.LINING, DigitCase.OLD_STYLE
            elementFormat.digitCase = DigitCase.DEFAULT;
            // DigitWidth.DEFAULT, DigitWidth.PROPORTIONAL, DigitWidth.TABULAR
            elementFormat.digitWidth = DigitWidth.TABULAR;
           // TextBaseline.ROMAN, TextBaseline.ASCENT, TextBaseline.DESCENT, TextBaseline.IDEOGRAPHIC_TOP, TextBaseline.IDEOGRAPHIC_CENTER, TextBaseline.IDEOGRAPHIC_BOTTOM
            elementFormat.dominantBaseline = TextBaseline.ROMAN;
            // FontDescription
            elementFormat.fontDescription = fontDescription;
            // Number
            elementFormat.fontSize = 12;
            // Kerning.ON, Kerning.OFF, Kerning.AUTO
            elementFormat.kerning= Kerning.ON;
            // LigatureLevel.NONE, LigatureLevel.MINIMUM, LigatureLevel.COMMON, LigatureLevel.UNCOMMON, LigatureLevel.EXOTIC
            elementFormat.ligatureLevel = LigatureLevel.NONE;
            // String
            elementFormat.locale = "ja";
            // true, false
            elementFormat.locked= false;
            // TextRotation.ROTATE_0, TextRotation.ROTATE_90, TextRotation.ROTATE_180, TextRotation.ROTATE_270, TextRotation.AUTO
            elementFormat.textRotation = TextRotation.AUTO;
            // Number
            elementFormat.trackingLeft = 0;
            // Number
            elementFormat.trackingRight = 0;
            // TypographicCase.DEFAULT, TypographicCase.TITLE, TypographicCase.CAPS, TypographicCase.SMALL_CAPS, TypographicCase.UPPERCASE, TypographicCase.LOWERCASE, TypographicCase.CAPS_AND_SMALL_CAPS
            elementFormat.typographicCase= TypographicCase.DEFAULT;
            
            return elementFormat;
        }
        
        
        // ContentElement : 表示内容
        private function createContentElement( content:*, elementFormat:ElementFormat ):ContentElement {
            // GraphicElement, GroupElement, TextElement
            var contentElement: ContentElement = new TextElement();
            
            //var graphicElement: GraphicElement= new GraphicElement();
            //var groupElement: GroupElement= new GroupElement();
            
            // ElementFormat
            contentElement.elementFormat = elementFormat;
            // EventDispatcher, 
            contentElement.eventMirror = null;
            // GroupElement
            contentElement.groupElement;// read-only
            // String
            contentElement.rawText;// read-only
            // String
            contentElement.text; // read-only
            // TextBlock
            contentElement.textBlock;// read-only
            // int
            contentElement.textBlockBeginIndex;// read-only
            // TextRotation.ROTATE_0, TextRotation.ROTATE_90, TextRotation.ROTATE_180, TextRotation.ROTATE_270, TextRotation.AUTO
            contentElement.textRotation = TextRotation.ROTATE_0;
            // *
            contentElement.userData;
            
            // for SubClass's elements
            switch( true ) {
                case contentElement is TextElement:
                    var textElement: TextElement = contentElement as TextElement;
                    var str:String = content as String;
                    textElement.text = str;
                break;
                case contentElement is GraphicElement:
                    var graphicElement: GraphicElement= contentElement as GraphicElement;
                    var display:DisplayObject = content as DisplayObject;
                    graphicElement.elementWidth = display.width;
                    graphicElement.elementHeight = display.height;
                    graphicElement.graphic= display;
                break;
                case contentElement is GroupElement:
                    var groupElement: GroupElement= contentElement as GroupElement;
                    groupElement.elementCount; // read-only
                    // getElementAt( index:int ):ContentElement;
                    // getElementAtCharIndex( charIndex:int ):ContentElement;
                    // mergeTextElements( element:ContentElement ):int;
                    // groupElements( beginIndex:int, endIndex:int ):GroupElement;
                    // replaceElements( beginIndex:int, endIndex:int ):TextElement;
                    //  setElements( value:Vector.<ContentElement> ):void;
                    // splitTextElement( elementIndex:int, splitIndex:int ):TextElement;
                    // ungroupElements( groupIndex:int ):void;
                break;
            }
            
            return textElement;
        }
        
        
        // TextJustifier : 整列設定
        private function createTextJustifier():TextJustifier {
            // EastAsianJustifier, SpaceJustifier, 
            var textJustifier:TextJustifier = new EastAsianJustifier("ja");
            // var textJustifier:TextJustifier = new SpaceJustifier("ja");
            // LineJustification.UNJUSTIFIED, LineJustification.ALL_BUT_LAST, LineJustification.ALL_INCLUDING_LAST
            textJustifier.lineJustification = LineJustification.ALL_BUT_LAST;
            
            switch( true ) {
                case textJustifier is EastAsianJustifier:
                    var eastAsianJustifier:EastAsianJustifier = textJustifier as EastAsianJustifier;
                    // JustificationStyle.PUSH_IN_KINSOKU, JustificationStyle.PUSH_OUT_ONLY, JustificationStyle.PRIORITIZE_LEAST_ADJUSTMENT
                    eastAsianJustifier.justificationStyle = JustificationStyle.PUSH_IN_KINSOKU;
                break;
                case textJustifier is SpaceJustifier:
                    var spaceJustifier:SpaceJustifier= textJustifier as SpaceJustifier;
                    // true , false
                    spaceJustifier.letterSpacing  = true;
                break;
            }
            return textJustifier;
        }
        
        
        // TextBlock : 段組設定
        private function createTextBlock( content:ContentElement, textJustifier:TextJustifier ):TextBlock {
            var textBlock:TextBlock = new TextBlock();
            // true, false
            textBlock.applyNonLinearFontScaling = true;
            // FontDescription
            textBlock.baselineFontDescription;
            // Number
            textBlock.baselineFontSize = 24;
            // TextBaseline.ROMAN, TextBaseline.ASCENT, TextBaseline.DESCENT, TextBaseline.IDEOGRAPHIC_TOP, TextBaseline.IDEOGRAPHIC_CENTER, TextBaseline.IDEOGRAPHIC_BOTTOM
            textBlock.baselineZero = TextBaseline.ROMAN;
            // int
            textBlock.bidiLevel 
            // TextElement, GraphicElement, GroupElement 
            textBlock.content = content;
            // TextLine 
            textBlock.firstInvalidLine; // read-only
            // TextLine 
            textBlock.firstLine; // read-only
            // TextLine 
            textBlock.lastLine; // read-only
            // TextRotation.ROTATE_0, TextRotation.ROTATE_90, TextRotation.ROTATE_180, TextRotation.ROTATE_270, TextRotation.AUTO
            textBlock.lineRotation = TextRotation.ROTATE_0;
            // Vector.<TabStop> 
            textBlock.tabStops;
            // EastAsianJustifier, SpaceJustifier, 
            textBlock.textJustifier = textJustifier;
            // TextLineCreationResult.SUCCESS, TextLineCreationResult.COMPLETE, TextLineCreationResult.INSUFFICIENT_WIDTH
            textBlock.textLineCreationResult// read-only
            // *
            textBlock.userData;
            
            return textBlock;
        }
        
    }
}
