/**
 * Copyright otias ( http://wonderfl.net/user/otias )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/q4Yl
 */

//とりあえずの覚え書き。

//////////////////////////////////////////////////////
/*  ToDo:
**    ・イベント周り整理
**    ・明度、彩度の調節
**    ・プレビュー中の他写真への切り替え
*/
//////////////////////////////////////////////////////

package {
	import flash.display.*;
	import flash.media.Camera;
	import flash.media.Video;
	import flash.geom.Matrix;
	import flash.events.*;
	import flash.utils.*;
	import caurina.transitions.Tweener;
	
	public class Shoot extends Sprite {
		private var camera:Camera;
		private var cameraHeight:Number = 349;
		private var video:Video;
		private var previewArea:Shape;
		private var curtain:Shape;
		private var images:Vector.<DisplayObject>;
		private var numFilms:int = -1;
		private var minScale:Number = 0.2;
		private var defaultWidth:Number = stage.stageWidth * minScale;
		private var defaultHeight:Number = cameraHeight * minScale;
		private var focusArea:Shape;
		private var shutter:QuickButton;
		private var closeBtn:QuickButton;
		private var timeoutId:uint;
		private var imagePos:Number;
		private var currentSelection:uint = 0;
		private var isFocus:Boolean = false;
		private var timer:Timer;
		
		public function Shoot() {
			init();
		}
		
		private function init():void {
			stage.quality = StageQuality.BEST;
			
			camera = Camera.getCamera();
			camera.addEventListener(ActivityEvent.ACTIVITY, cameraActivated, false, 0, true);
			if(camera) {
				video = new Video(stage.stageWidth, cameraHeight);
				video.attachCamera(camera);
				video.smoothing = true;
				images = new Vector.<DisplayObject>();
				
				previewArea = new Shape();
				with(previewArea.graphics) {
					beginFill(0x000000, 0.7);
					drawRect(0, 0, stage.stageWidth, stage.stageHeight * 0.25);
				}
				previewArea.y = stage.stageWidth - stage.stageHeight * 0.25;
				
				focusArea = new Shape();
				with(focusArea.graphics) {
					lineStyle(2, 0xFFFFFF);
					drawRect(0, 0, defaultWidth - 2, defaultHeight - 2);
				}
				focusArea.alpha = 0;
				
				curtain = new Shape();
				with(curtain.graphics) {
					beginFill(0x000000);
					drawRect(0, 0, stage.stageWidth, stage.stageHeight);
					endFill();
				}
				
				shutter = new QuickButton(60, 25, 0x18D9D9, "shoot!", 10);
				shutter.addEventListener(MouseEvent.CLICK, shooting, false, 0, true);
				shutter.x = 10;
				shutter.y = 10;
				
				closeBtn = new QuickButton(65, 25, 0xFF4141, "close", 10);
				closeBtn.addEventListener(MouseEvent.CLICK, reduce, false, 0, true);
				closeBtn.x = stage.stageWidth - 75;
				closeBtn.y = -100;
				
				addChild(video);
				addChild(previewArea);
				addChild(focusArea);
				addChild(shutter);
				addChild(curtain);
				addChild(closeBtn);
			} else {
				return;
			}
		}
		
		private function cameraActivated(e:ActivityEvent):void {
			Tweener.addTween(curtain, {alpha: 0, time: 2, delay: 0.2});
			timer = new Timer(33);
			timer.addEventListener(TimerEvent.TIMER, showPreviews, false, 0, true);
			timer.start();
			camera.removeEventListener(ActivityEvent.ACTIVITY, cameraActivated);
		}
		
		private function shooting(e:MouseEvent):void {
			shutter.removeEventListener(MouseEvent.CLICK, shooting);
			timer.stop();
			var matrix:Matrix =  new Matrix();
			matrix.scale(1, 1);
			var snapBmd:BitmapData = new BitmapData(video.width, video.height, true, 0xFFFFFFFF);
			snapBmd.draw(video, matrix);
			var image:Bitmap = new Bitmap(snapBmd);
			var imageContainer:Sprite = new Sprite();
			imageContainer.addChild(image);
			
			numFilms++;
			images.push(imageContainer);
			images[numFilms].addEventListener(MouseEvent.MOUSE_DOWN, enlarge, false, 0, true);
			images[numFilms].addEventListener(MouseEvent.MOUSE_OVER, focusIn, false, 0, true);
			addChild(images[numFilms]);
			setChildIndex(shutter, numChildren - 1);
			timeoutId = setTimeout(scaling, 1000);
		}
		
		private function scaling():void {
			Tweener.addTween(previewArea, {y: stage.stageHeight - stage.stageHeight * 0.25, time: 1});
			
			if(images.length >= 1) {
				for(var i:uint = 0; i < images.length; i++) {
					Tweener.addTween(images[i], {y: imagePos, time: 1});
				}
			}
			
			Tweener.addTween(images[numFilms],
							{ scaleX: minScale,
							  scaleY: minScale,
							  x: defaultWidth * numFilms,
							  y: cameraHeight + previewArea.height / 2 - defaultHeight / 2,
							  time: 1
							});
			
			timeoutId = setTimeout(f, 1000);
			function f():void {
				Tweener.removeAllTweens();
				shutter.addEventListener(MouseEvent.CLICK, shooting, false, 0, true);
				timer.start();
			}
		}
		
		private function showPreviews(e:TimerEvent):void {
			var ratioY:Number = stage.stageHeight - stage.stageHeight * 0.25;
			if(mouseY >= ratioY) {
				previewArea.y += simpleEaseOut(previewArea.y, ratioY, 0.2);
			} else {
				previewArea.y += simpleEaseOut(previewArea.y, stage.stageHeight, 0.2);
			}
			
			if(images.length >= 1) {
				imagePos = ratioY + previewArea.height / 2 - images[0].height / 2;
				for(var i:uint = 0; i < images.length; i++) {
					images[i].y = previewArea.y + previewArea.height / 2 - images[i].height / 2;
					focusArea.y = images[i].y + 1;
					if(isFocus) {
						focusArea.alpha = 1;
					} else {
						focusArea.alpha = 0;
					}
				}
			}
		}
		
		private function focusIn(e:MouseEvent):void {
			isFocus = true;
			setChildIndex(focusArea, numChildren - 1);
			focusArea.x = e.target.x + 1;
			e.target.addEventListener(MouseEvent.MOUSE_OUT, focusOut, false, 0, true);
		}
		
		private function focusOut(e:MouseEvent):void {
			isFocus = false;
			e.target.removeEventListener(MouseEvent.MOUSE_OUT, focusOut);
		}
		
		private function enlarge(e:MouseEvent):void {
			focusArea.alpha = 0;
			timer.stop();
			setChildIndex(closeBtn, numChildren - 1);
			Tweener.addTween(closeBtn, {y: 10, delay: 0.5, time: 1});
			
			for(var i:uint = 0; i < images.length; i++) {
				if(e.target == images[i]) {
					currentSelection = i;
					setChildIndex(images[i], getChildIndex(closeBtn) - 1);
					Tweener.addTween(images[i], {scaleX: 1, scaleY: 1, x: 0, y: 0, delay: 0.5, time: 1});
				}
			}
		}
		
		private function reduce(e:MouseEvent):void {
			Tweener.addTween(images[currentSelection],
							 {
							  scaleX: minScale,
							  scaleY: minScale,
							  x: defaultWidth * currentSelection,
							  y: cameraHeight + previewArea.height / 2 - defaultHeight / 2,
							  delay: 0.2,
							  time: 1
							});
			
			Tweener.addTween(closeBtn, {y: -100, delay: 0.2, time: 1});
			
			timeoutId = setTimeout(f, 1000);
			function f():void {
				Tweener.removeAllTweens();
				timer.start();
			}
		}
		
		private function simpleEaseOut(currentPos:Number, targetPos:Number, easing:Number):Number {
			return (targetPos - currentPos) * easing;
		}
	}
}

import flash.display.Sprite;
import flash.display.Shape;
import flash.display.SimpleButton;
import flash.filters.DropShadowFilter;
import flash.text.TextField;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.text.TextFieldAutoSize;
	
class QuickButton extends Sprite {
	private var button:SimpleButton;
	private var _w:Number;
	private var _h:Number;
	private var _color:Number;
	private var _text:String;
	private var _textColor:uint;
	private var _roundness:Number;
	private var _upShadow:DropShadowFilter = new DropShadowFilter(3, 45, 0x000000, 0.7, 3, 3);
	private var _downShadow:DropShadowFilter = new DropShadowFilter(1, 45, 0x000000, 0.7, 3, 3);
		
	public function QuickButton(w:Number = 150, h:Number = 30, color:uint = 0xFF0000, txt:String = "Button", txtColor:uint = 0x000000, roundness:Number = 6) {
		_w = w;
		_h = h;
		_color = color;
		_text = txt;
		_textColor = txtColor;
		_roundness = roundness;
		init();
	}

	private function init():void {
		button = createButton();
		addChild(button);
		
		var txt:TextField = createText();
		txt.x = _w / 2 - txt.width / 2;
		txt.y = _h / 2 - txt.height / 2;
		txt.mouseEnabled = false;
		addChild(txt);
	}
	
	private function createButton():SimpleButton {
		var btn:SimpleButton = new SimpleButton();
		var overColor:uint = 0xCECECE;
		var downColor:uint = 0xEEE;
		btn.upState = createBody(_color, "up");
		btn.overState = createBody(overColor, "over");
		btn.downState = createBody(downColor, "down");
		btn.hitTestState = btn.downState;
		btn.useHandCursor = true;
		return btn;
	}
		
	private function createBody(color:uint, mode:String):Shape {
		var body:Shape = new Shape();
		with(body.graphics) {
			beginFill(color, 1);
			drawRoundRect(0, 0, _w, _h, _roundness, _roundness);
			endFill();
		}
		
		if(mode == "over" || mode == "up") {
			body.filters = [_upShadow];
		} else if(mode == "down" || mode == "hit") {
			body.filters = [_downShadow];
		}
		
		return body;
	}
	
	private function createText():TextField {
		var fmt:TextFormat =  new TextFormat();
		with(fmt) {
			color = _textColor;
			size = Math.round(_h * 0.6);
			font = "Arial"
			align = TextFormatAlign.LEFT;
		}
		
		var fld:TextField = new TextField();
		with(fld) {
			defaultTextFormat = fmt;
			selectable = false;
			autoSize = TextFieldAutoSize.LEFT;
			text = _text;
		}
		
		return fld;
	}
}