/**
 * Copyright Kay ( http://wonderfl.net/user/Kay )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/q4Pa
 */

// forked from Kay's forked from: 透視投影テスト
// forked from Kay's 透視投影テスト
/*
 * 単純なボックスを並べた透視投影テスト
 * 各Boxに回転を加える
 * それぞれ勝手な角度で回転
 */

package {
	
	import flash.display.*;
	import flash.geom.*;
	import flash.events.*;
	
	[SWF(width=465,height=465,frameRate=30,backgroundColor=0xffffff)]
	public class Main extends Sprite {
		
		private const SW:Number = stage.stageWidth;
		private const SH:Number = stage.stageHeight;
		public var proj:PerspectiveProjection = new PerspectiveProjection();
		
		public function Main():void {
			proj.fieldOfView = 80;

			var container:Sprite = new Sprite();
			addChild(container);
			container.x = SW/2;
			container.y = SH/2;

			var boxNum:uint = 4;
			var dist:Number = 75;
			var shift:Number = dist*(boxNum-1)/2;
			for (var d:int = 0; d < boxNum; d++) {
				var nZ:Number = dist*d-shift;
				for (var v:int = 0; v < boxNum; v++) {
					var nY:Number = dist*v-shift;
					for (var h:int = 0; h < boxNum; h++) {
						var nX:Number = dist*h-shift;
						var box:Box = new Box();
						container.addChild(box);
						box.mtx.prepend(proj.toMatrix3D());
						box.mtx.prependTranslation(nX, nY, proj.focalLength-nZ);
						box.rX = Math.random()*8-4;
						box.rY = Math.random()*8-4;
						box.rZ = Math.random()*8-4;
						box.xRender();
						box.addEventListener(Event.ENTER_FRAME, xRotate);
					}
				}
			}
		}
		public function xRotate(e:Event):void {
			// Boxの座標を回転させる
			e.target.rMtx.appendRotation(e.target.rX,Vector3D.X_AXIS);
			e.target.rMtx.appendRotation(e.target.rY,Vector3D.Y_AXIS);
			e.target.rMtx.appendRotation(e.target.rZ,Vector3D.Z_AXIS);
			//e.target.mtx.appendRotation(0.2, Vector3D.Z_AXIS);
			e.target.xRender();
		}
	}
}

import flash.display.*;
import flash.geom.*;

class Box extends Sprite {
	
	private const len:Number = 12;
	public var vertices3D:Vector.<Number> = new Vector.<Number>();
	public var vertices2D:Vector.<Number> = new Vector.<Number>();
	public var indices:Vector.<int> = new Vector.<int>();
	public var uvt:Vector.<Number> = new Vector.<Number>();
	public var mtx:Matrix3D = new Matrix3D();
	public var rMtx:Matrix3D = new Matrix3D();
	public var rX:Number;
	public var rY:Number;
	public var rZ:Number;
	public var colors:Array = new Array(0xff6666,0x66ff66,0x6666ff,0x66cccc,0xcc66cc,0xcccc66);
	
	public function Box():void {
		vertices3D.push(-len,-len, len);
		vertices3D.push( len,-len, len);
		vertices3D.push(-len,-len,-len);
		vertices3D.push( len,-len,-len);
		vertices3D.push(-len, len, len);
		vertices3D.push( len, len, len);
		vertices3D.push(-len, len,-len);
		vertices3D.push( len, len,-len);
		indices.push(2,3,7, 7,6,2);
		indices.push(3,1,5, 5,7,3);
		indices.push(1,0,4, 4,5,1);
		indices.push(0,2,6, 6,4,0);
		indices.push(0,1,3, 3,2,0);
		indices.push(6,7,5, 5,4,6);
	}
	
	public function xRender():void {
		// 回転させた座標に透視投影を反映してから2D座標に変換する
		var tempVerts:Vector.<Number> = new Vector.<Number>;
		rMtx.transformVectors(vertices3D, tempVerts);
		Utils3D.projectVectors(mtx,tempVerts,vertices2D,uvt);
		graphics.clear();
		for (var i:int = 0; i < 6; i++) {
			graphics.beginFill(colors[i]);
			graphics.drawTriangles(vertices2D,indices.slice(i*6,i*6+6),null,TriangleCulling.NEGATIVE);
			graphics.endFill();
		}
	}
}