/**
 * Copyright nicoptere ( http://wonderfl.net/user/nicoptere )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/q4O8
 */

package 
package shapes.shapes2D.distribution 
{
	import flash.geom.Point;
	/**
	 * @author Nicolas Barradeau
	 * http://en.nicoptere.net
	 */
	public class Disc
	{
		
		public var center:Point;
		public var radiusX:Number;
		public var radiusY:Number;
		public var innerRadiusX:Number;
		public var innerRadiusY:Number;
		private var points:Vector.<Point>;
		
		public function Disc( center:Point, radiusX:Number, radiusY:Number, innerRadiusX:Number = 0, innerRadiusY:Number = 0 ) 
		{
			this.center = center;
			this.radiusX = radiusX;
			this.radiusY = radiusY;
			this.innerRadiusX = innerRadiusX;
			this.innerRadiusY = innerRadiusY;
		}
		
		
		public function distribute( count:uint, shuffle:Boolean = false, jitter:Number = 0 ):Vector.<Point>
		{
			
			points = new Vector.<Point>();
			
			count /= 2;
			
			var p:Point, i:int, angle:Number;
			var angleStep:Number = ( Math.PI * 2 ) / count;
			
			for ( i = 0; i < count; i++ )
			{
				
				angle = i * angleStep;
				
				if ( jitter != 0 )
				{
					
					p = new Point();
					p.x = center.x + Math.cos( angle ) * ( radiusX - ( Math.random() * .5 * jitter ) );
					p.y = center.y + Math.sin( angle ) * ( radiusY - ( Math.random() * .5 * jitter ) );
					points.push( p );
					
					p = new Point();
					p.x = center.x + Math.cos( angle ) * ( innerRadiusX + ( Math.random() * .5 * jitter ) );
					p.y = center.y + Math.sin( angle ) * ( innerRadiusY + ( Math.random() * .5 * jitter ) );
					points.push( p );
					
				}
				else
				{
					p = new Point();
					p.x = center.x + Math.cos( angle ) * radiusX;
					p.y = center.y + Math.sin( angle ) * radiusY;
					points.push( p );
					
					p = new Point();
					p.x = center.x + Math.cos( angle ) * innerRadiusX;
					p.y = center.y + Math.sin( angle ) * innerRadiusY;
					points.push( p );
				}
				
				
			}
			
			if ( shuffle ) 	points.sort( this.shuffle );
			
			return points;
			
		}
		
		private function shuffle( a:Number, b:Number ):int
		{
			return ( Math.random() > .5 ) ? 1 : -1;
		}
		
	}

}