/**
 * Copyright jmbyh521 ( http://wonderfl.net/user/jmbyh521 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/q2cQ
 */

// forked from WLAD's forked from: ねばねば効果
// forked from nemu90kWw's ねばねば効果
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.geom.ColorTransform;
    import flash.utils.setInterval;
    
    [SWF(width = "465", height = "465", frameRate = "60", backgroundColor="#A08040")]
    public class PaletteScroll extends Sprite
    {
        public function PaletteScroll()
        {
            graphics.beginFill(0xA08040);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            
            var bmp:BitmapData = new BitmapData(465, 465, true, 0);
            var display:Bitmap = new Bitmap(bmp);
            bmp.perlinNoise(80, 80, 2, Math.random() * 1000, true, true, 15, false);
            bmp.colorTransform(bmp.rect, new ColorTransform(2, 2, 2, 9, -256, -256, -256, -1024));
            addChild(display);
            
            display.x = 0;
            display.y = 0;
            
            var effect:PaletteScrollEffect = new PaletteScrollEffect(display);
            
            effect.x = 0;
            effect.y = 0;
            addChild(effect);
            
            var offset:int = 0;
            setInterval(function():void
            {
                effect.offset = offset % 256;
                offset += 1;
            }, 1);
        }
    }
}

    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.display.BlendMode;
    import flash.display.DisplayObject;
    import flash.filters.ColorMatrixFilter;
    import flash.geom.Point;
    
    class PaletteScrollEffect extends Bitmap
    {
        private var source:BitmapData;
        private var cache:Vector.<BitmapData>;
        
        private const CACHE_DIVIDE:int = 256;

        public function PaletteScrollEffect(target:DisplayObject)
        {
            source = new BitmapData(target.width, target.height, true, 0);
            source.draw(target);
            source.applyFilter(source, source.rect, new Point(0, 0), new ColorMatrixFilter(
                [1/3, 1/3, 1/3, 0, 0, 
                 1/3, 1/3, 1/3, 0, 0, 
                 1/3, 1/3, 1/3, 0, 0,
                   0,   0,   0, 1, 0]));
            
            cache = new Vector.<BitmapData>();
            for (var i:int = 0; i < CACHE_DIVIDE; i++) 
            {
                cache.push(null);
            }
            
            bitmapData = new BitmapData(source.width, source.height, true, 0);
            blendMode = BlendMode.ADD;
            offset = 0;
        }
        
        public function set offset(num:int):void
        {
            num = Math.floor((num % 256) / (256 / CACHE_DIVIDE));
            
            if(cache[num] == null)
            {
                cache[num] = new BitmapData(source.width, source.height, true, 0);
                
                var palette:Array = new Array();
                for (var i:int = 0; i < 256; i++) 
                {
                    var c:int = 256 - (((num * (256 / CACHE_DIVIDE)) + i) % 256);
                    palette.unshift(c + (c << 8) + (c << 16) + 0xFF000000);
                }
                cache[num].paletteMap(source, source.rect, new Point(0, 0), palette, palette, palette);
                cache[num].copyChannel(source, source.rect, new Point(0, 0), BitmapDataChannel.ALPHA, BitmapDataChannel.ALPHA);
            }
            
            bitmapData = cache[num];
        }
    }