/**
 * Copyright yanbaka ( http://wonderfl.net/user/yanbaka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/q1sx
 */

package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.ColorTransform;
	
    [SWF(width = "465", height = "465", backgroundColor = "0x000000", frameRate = "30")]
	public class Hearts3 extends Sprite
	{
		private const WIDHT:Number = stage.stageWidth;
		private const HEIGHT:Number = stage.stageHeight;
		
		private var _canvas:BitmapData;
		private var _bmd:BitmapData;
		private var hearts:Array = [];
		private var isDown:Boolean = false;
		private var cTra:ColorTransform =  new ColorTransform(.9);
		
		
		public function Hearts3()
		{
			graphics.beginFill(0x0);
			graphics.drawRect(0, 0, WIDHT, HEIGHT);
			
			_canvas = new BitmapData(WIDHT, HEIGHT, false, 0x0);
			addChild(new Bitmap(_canvas));
			
			stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
			stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
			addEventListener(Event.ENTER_FRAME, loop);
		}
		
		private function mouseDownHandler(e:MouseEvent):void
		{
			isDown = true;
		}
		
		private function mouseUpHandler(e:MouseEvent):void
		{
			isDown = false;
		}
		
		private function loop(e:Event):void
		{
			if(isDown)
			{
				add();
			}
			
			update();
		}
		
		private function add():void
		{
			if(hearts.length > 30000) return;
			
			var times:int = Math.random()*25+5;
			var model:Array = createModel();
			var l:int = model[2];
			for (var i:int=0; i<l; i+=5)
			{
				var heart:Heart = new Heart();
				heart.sx = mouseX;
				heart.sy = mouseY;
				heart.ex = model[0][i]*times + mouseX;
				heart.ey = model[1][i]*times + mouseY;
				hearts.push(heart);
			}
		}
		
		private function update():void
		{
			_canvas.lock();
			_canvas.colorTransform(_canvas.rect, cTra);
			var i:int = hearts.length;
			while(i--)
			{
				var heart:Heart = hearts[i];
				heart.sx += (heart.ex - heart.sx)/10;
				heart.sy += (heart.ey - heart.sy)/10;
				heart.cnt--;
				if(heart.cnt < 0)
				{
					hearts.splice(i, 1);
				}
				_canvas.setPixel(heart.sx, heart.sy, 0xFF0000);
			}
			_canvas.unlock();
		}
		
		private function createModel():Array
		{
			var sx:Number;
			var sy:Number;
			var b:Number = 0.8;
			var i:int = 0;
			var xmax:Number = 1;
			var dx:Number = xmax/1000;
			var xx:Array = [];
			var yy:Array = [];
			
			for (sx=0;sx<=xmax;sx=sx+dx)
			{
				xx[i] = sx;
				sy = Math.sqrt(1-sx*sx)-b*Math.sqrt(sx);
				yy[i] = sy;
				
				i++;
			}
			
			for (sx=xmax;sx>=0;sx=sx-dx)
			{
				xx[i] = sx;
				sy = -Math.sqrt(1-sx*sx)-b*Math.sqrt(sx);
				yy[i] = sy;
				
				i++;
			}
			
			for (sx=0;sx>=-xmax;sx=sx-dx)
			{
				xx[i] = sx;
				sy = -Math.sqrt(1-sx*sx)-b*Math.sqrt(-sx);
				yy[i] = sy;
				
				i++;
			}
			
			for (sx=-xmax;sx<=0;sx=sx+dx)
			{
				xx[i] = sx;
				sy = Math.sqrt(1-sx*sx)-b*Math.sqrt(-sx);
				yy[i] = sy;
				
				i++;
			}
			
			return [xx, yy, i];
		}
	}
}

class Heart
{
	public var sx:Number;
	public var sy:Number;
	public var ex:Number;
	public var ey:Number;
	public var cnt:int = 20;
	
	public function Heart(){}
}