/**
 * Copyright gggiyeok ( http://wonderfl.net/user/gggiyeok )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/q0SB
 */

package{
    import flash.text.engine.TextBlock;
    import flash.text.engine.TextElement;
    import flash.text.engine.TextLine;
    import flash.text.engine.ElementFormat;
    import flash.text.engine.ContentElement;
    import flash.events.MouseEvent;
    import flash.events.Event;
    import flash.text.engine.GroupElement;
    import flash.geom.Rectangle;
    import flash.display.Sprite;

    public class SelectionText extends Sprite {
       private var left:Sprite;
       private var right:Sprite;
       private var beginIndex:int = 0;
        private var endIndex:int = 0;
        private var limit:int = 100;
        private var rectUnionBg:Sprite;
        private var startLine:TextLine;
        private var currentLine:TextLine;
       // private 
        private var tb:TextBlock ;
        private var textElement:TextElement;
        private var groupVector:Vector.<ContentElement>;
        private var pattern:RegExp = /[^a-zA-Z가-힝\-]/;
        private var txtW:int = 465;
        private var line:TextLine;
        private var lines:Vector.<TextLine> = new Vector.<TextLine>();
        public function SelectionText() {
            addChild(rectUnionBg = new Sprite());  
            tb = new TextBlock();
            var str:String = <![CDATA[알루미늄 캔이든 유리병이든 모든 음료수 용기는 원통형이다 
보험에 따라 치료가 다르다고?
어떤 경우든 의사들이 환자들을 위해 최선을 다하리라는 사실은 의심의 여지가 없다. 하지만 모호한 경우는 언제나 있기 마련이다. 예를 들어 무릎에 통증이 있는 환자의 경우 단지 몇 주 무릎을 사용하지 않는 것만으로도 증세가 호전될 수 있다. 그렇지 않고 비용이 많이 드는 정밀검사를 하면 무릎 조직이 손상된 것을 발견하게 될지도 모른다. 이때 최선의 방책은 수술을 하는 것이다. 건강관리기구의 경우에는 검사 비용도 의사의 부담이 되어버리기 때문에 당연히 증세를 좀더 두고 보자는 의사들이 나올 수밖에 없다. 일반 건강보험의 경우 의사는 똑같은 환자에 대해 당장 정밀검사를 실시할 인센티브가 훨씬 강하다. (119쪽)

경제학자들이 어려운 수학을 쓰는 이유는?
다른 분야와 마찬가지로 경제학에서도 지적 능력이란 상대적인 것이다. 수학적 형식주의에 매달리는 경제학자들이 많아질수록 지적 능력을 암시하는 경계선도 올라가게 마련이다. 결국 이로 인한 경쟁이 과도한 형식주의로 이어진 것이다. 경제학에서 수학적 형식주의가 차지하는 비중이 지나치게 높아지는 것은 칵테일파티에 모인 사람들이 점점 목소리를 높이는 것과 똑같은 이유에서이다. 사람들이 모여 있는 시끄러운 장소에서 다른 사람들에게 말을 하려면 목소리를 높여야 한다. 그러나 모든 사람들이 목소리를 높이면 주위가 더 시끄러워지기 때문에 사람들은 점점 더 큰 소리로 말할 수밖에 없게 된다. (221쪽)

]]>;            
            textElement = new TextElement(str, new ElementFormat(null,16));   
            groupVector = new Vector.<ContentElement>();   
            groupVector.push(textElement);
             tb.content =  new GroupElement(groupVector);
            line = tb.createTextLine(null,txtW);
           
            var posy:int = 0; 
            while (line)
            {
                posy +=  line.ascent + 2;
                line.y = posy;
                line.addEventListener(MouseEvent.CLICK, click);
                addChild(line);
                lines.push(line);
                line = tb.createTextLine(line,txtW);
    
            }
    
            left = createHandle(-30);
            right = createHandle(30);
            left.visible = right.visible = false;
        }
        

        
        

        private function createHandle(h:int):Sprite{
            var spr:Sprite  = new Sprite();
            with(spr.graphics){
                lineStyle(1);
                moveTo(0, 0);
                lineTo(0, h);
                beginFill(0x0);
                drawCircle(0, h, 5);
                endFill();
            }
            return addChild(spr) as Sprite; 
        }
        private function click(e:MouseEvent):void
        {
            var line:TextLine = e.target as TextLine;
            var index:int = line.getAtomIndexAtPoint(mouseX,mouseY);
            var str:String = line.textBlock.content.text;
            var i:int = line.textBlockBeginIndex + index;
            
            if (str.charAt(i).match(pattern) != null)
            {
                return;
            }
            while (--i)
            {
                if (str.charAt(i).match(pattern) != null)
                {
                    i++;
                    break;
                }
                if (i < 0)
                {
                    i = 0;
                    break;
                }

                if (limit++ > 1000)
                {
                    return;
                }
            }
            beginIndex = i;
            i = line.textBlockBeginIndex + index;
            while (++i)
            {
                if (str.charAt(i).match(pattern) != null)
                {
                    i--;
                    break;
                }
                if (i > str.length - 1)
                {
                    i = str.length - 1;
                    break;
                }
                if (limit++ > 1000)
                {
                    trace('while');
                    return;
                }
            }
            endIndex = i;
            var rects:Vector.<Rectangle> = drawBackground(beginIndex, endIndex);
            addHandle(endIndex);
            addHandleLeft(beginIndex);
            left.visible = right.visible = true;

        }




        private function addHandleLeft(endIndex:int):void
        {
            left.x = mouseX;
            left.y = mouseY;
            var line:TextLine;
            var atomIndex:int = beginIndex;
            for (var i:int = 0; i < lines.length; i++)
            {
                line = lines[i];
                if (line.textBlockBeginIndex <= beginIndex && (line.textBlockBeginIndex + line.rawTextLength) > beginIndex)
                {
                    atomIndex -=  line.textBlockBeginIndex;
                    break;
                }

            }
            startLine = line;
            var rect:Rectangle = line.getAtomBounds(atomIndex);
            left.y = rect.y + line.y + line.height;
            left.x = rect.x;
            left.addEventListener(MouseEvent.MOUSE_DOWN, dragStartLeft);
            
        }
        private function dragStartLeft(e:MouseEvent):void
        {
            left.addEventListener(Event.ENTER_FRAME, dragLeft);
            stage.addEventListener(MouseEvent.MOUSE_UP, dragEndLeft);
        }
        private function dragLeft(e:Event):void
        {
            var py:int = mouseY + 25;
            var px:int = mouseX;
            if(py > startLine.y) py = startLine.y+2
            
            var index:int;
            for (var i:int = 0; i < lines.length; i++)
            {
                line = lines[i];
                index = line.getAtomIndexAtPoint(2 ,py);
                if (index > -1)
                {
                    index = line.getAtomIndexAtPoint(px ,py);
                    if(index < 0){
                        index = 0;
                    }
                    break;
                }
            }
            if (index > -1)
            {
                beginIndex = line.textBlockBeginIndex + index;
                if (beginIndex > endIndex)
                {
                    beginIndex = endIndex;
                    index =  line.rawTextLength -(line.textBlockBeginIndex + beginIndex-1)+1;

                }
                if (index > -1)
                {
                    var rects:Vector.<Rectangle> = drawBackground(beginIndex, endIndex);
                    var rect:Rectangle = line.getAtomBounds(index);
                    left.y = rect.y + line.y + line.height;
                    left.x = rect.x;
                }
            }
            currentLine = line;
        }
        private function dragEndLeft(e:MouseEvent):void
        {
            left.removeEventListener(Event.ENTER_FRAME, dragLeft);
            stage.removeEventListener(MouseEvent.MOUSE_UP, dragEnd);
            startLine = currentLine;
        }
        private function addHandle(endIndex:int):void
        {
            right.x = mouseX;
            right.y = mouseY;
            var line:TextLine;
            var atomIndex:int = endIndex;
            for (var i:int = 0; i < lines.length; i++)
            {
                line = lines[i];
                if (line.textBlockBeginIndex <= endIndex && (line.textBlockBeginIndex + line.rawTextLength) >= endIndex)
                {
                    atomIndex -=  line.textBlockBeginIndex;
                    break;
                }

            }
            startLine = line;
            var rect:Rectangle = line.getAtomBounds(atomIndex);
            right.y = rect.y + line.y;
            right.x = rect.x + rect.width;
            right.addEventListener(MouseEvent.MOUSE_DOWN, dragStart);
        }
        private function dragStart(e:MouseEvent):void
        {
            right.addEventListener(Event.ENTER_FRAME, dragRight);
            stage.addEventListener(MouseEvent.MOUSE_UP, dragEnd);
        }

        private function dragRight(e:Event):void
        {
            var py:int = mouseY - 25;
            var px:int = mouseX;
            if(py < startLine.y) py = startLine.y+2;
            var index:int;
            for (var i:int = 0; i < lines.length; i++)
            {
                line = lines[i];
                index = line.getAtomIndexAtPoint(10 ,py);
                if (index > -1)
                {
                    index = line.getAtomIndexAtPoint(px ,py);
                    if( index < -1){
                        index = line.rawTextLength - 1;
                    }
                    break;
                }
            }
            if (index > -1)
            {
                endIndex = line.textBlockBeginIndex + index;
                if (beginIndex > endIndex)
                {
                    endIndex = beginIndex;
                    index =  line.rawTextLength -(line.textBlockBeginIndex + beginIndex-1)+1;
                }
                if (index > -1)
                {
                    var rects:Vector.<Rectangle> = drawBackground(beginIndex, endIndex);
                    var rect:Rectangle = line.getAtomBounds(index);
                    right.y = rect.y + line.y;
                    right.x = rect.x + rect.width;
                }
            }
            currentLine = line;
        }

        private function dragEnd(e:MouseEvent):void
        {
            right.removeEventListener(Event.ENTER_FRAME, dragRight);
            stage.removeEventListener(MouseEvent.MOUSE_UP, dragEnd);
            startLine = currentLine;
        }
        private function drawBackground(begin:int, end:int):Vector.<Rectangle>
        {
            graphics.clear();
            var rects:Vector.<Rectangle> = new Vector.<Rectangle>();
            if (begin > end)
            {
                 var begin2:int = begin;
                 begin = end;
                end = begin2;
            }

            var line:TextLine;
            for (var i:int = 0; i < lines.length; i++)
            {
                line = lines[i];
                if (line.textBlockBeginIndex <= begin && (line.textBlockBeginIndex + line.rawTextLength-1) >= begin)
                {
                    break;
                }
            }

            var startLine:TextLine = line;

            for (i = 0; i < lines.length; i++)
            {
                line = lines[i];
                if (line.textBlockBeginIndex <= end && (line.textBlockBeginIndex + line.rawTextLength-1) >= end)
                {
                    break;
                }
            }

            var endLine:TextLine = line;
            line = startLine;
            var bounds:Rectangle;

            try
            {
                while (true)
                {
                    if (line == null)
                    {
                        break;
                    }

                    if (line == startLine)
                    {
                        if (startLine == endLine)
                        {
                            bounds = line.getAtomBounds(Math.min(Math.max(begin - line.textBlockBeginIndex,0),line.rawTextLength - 1)).union(line.getAtomBounds(Math.min(Math.max(end - line.textBlockBeginIndex,0),line.rawTextLength - 1)));
                        }
                        else
                        {
                            bounds = line.getAtomBounds(Math.min(Math.max(begin - line.textBlockBeginIndex,0),line.rawTextLength - 1)).union(line.getAtomBounds(line.rawTextLength - 1));
                        }
                        bounds.x +=  line.x;
                        bounds.y +=  line.y;
                    }
                    else if (line == endLine)
                    {
                        bounds = line.getAtomBounds(Math.min(Math.max(end - line.textBlockBeginIndex,0),line.rawTextLength - 1)).union(line.getAtomBounds(0));
                        bounds.x +=  line.x;
                        bounds.y +=  line.y;
                    }
                    else
                    {
                        bounds = line.getBounds(line.parent);

                    }
                    graphics.beginFill(0x003399, 0.25);
                    graphics.drawRect(bounds.x, bounds.y, bounds.width, bounds.height);
                    rects.push(bounds);
                    if (line == endLine)
                    {
                        break;
                    }

                    line = line.nextLine;
                }
                
            }
            catch (e:Error)
            {
            }
            return rects;
        }

    }
}

