/**
 * Copyright Vaxtor ( http://wonderfl.net/user/Vaxtor )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/q0GY
 */

package {
    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.text.TextFormat;
    import flash.text.TextField;
    import flash.display.BitmapData;
    import flash.filters.GlowFilter;
    import flash.events.Event;
    
    [SWF(width = "465", height = "84", frameRate = "24", backgroundColor = "0xFFFFFF")]
    public class LEDSign extends Sprite {
        private const SCALE:Number = 3;
        
        public function LEDSign() {
            createBackground();
            createText("Tsunami Alert for New Zealand, the Philippines, Indonesia, Papua New Guinea, Hawaii, and others. Waves expected over the next few hours, caused by 8.9 earthquake in Japan.");
        }
        
        private function createBackground():void {
            var background:Sprite = new Sprite();
            background.graphics.beginFill(0x000000);
            background.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            background.graphics.endFill();
            
            for (var i:int = 0; i <= stage.stageWidth; i += SCALE) {
                for (var j:int = 0; j <= stage.stageHeight; j += SCALE) {
                    var dot:Shape = new Shape();
                    dot.graphics.beginFill(0x400000);
                    dot.graphics.drawCircle(0, 0, .5 * SCALE);
                    dot.graphics.endFill();
                    dot.x = i;
                    dot.y = j;
                    background.addChild(dot);
                }
            }
            
            addChild(background);
        }
        
        private function createText(str:String):void {
            var text:Sprite = new Sprite();
            
            var fmt:TextFormat = new TextFormat();
            fmt.font = "Arial";
            fmt.size = 20;
            fmt.color = 0xffffff;
            fmt.bold = true;
            fmt.letterSpacing = 2;
            
            var tf:TextField = new TextField();
            tf.autoSize = "left";
            tf.defaultTextFormat = fmt;
            tf.text = str;
        
            var bmd:BitmapData = new BitmapData(tf.width, tf.height, true, 0x000000);
            bmd.draw(tf);
        
            for (var i:int = 0; i < bmd.width; i++) {
                for (var j:int = 0; j < bmd.height; j++) {
                    if (bmd.getPixel(i, j) > 0x000000) {
                        var dot:Shape = new Shape();
                        dot.graphics.beginFill(0xFF0000);
                        dot.graphics.drawCircle(0, 0, .5 * SCALE);
                        dot.graphics.endFill();
                        dot.x = i * SCALE;
                        dot.y = j * SCALE;
                        text.addChild(dot);
                    }
                }
            }
            
            text.alpha = 0;
            text.filters = [new GlowFilter(0xFF0000, 1, SCALE * 2, SCALE * 2, .7, 3)];
            text.addEventListener(Event.ENTER_FRAME, moveText, false, 0, true);
            addChild(text);
        }
        
        private function moveText(e:Event):void {
            var text:Sprite = e.target as Sprite;
            
            if (text.alpha < 1) {
                text.alpha += .1;
            } else {
                text.x -= SCALE;
                
                if (text.x < -text.width) {
                    text.x = Math.ceil(stage.stageWidth / SCALE) * SCALE;
                }
            }
        }
    }
}