/**
 * Copyright Murai ( http://wonderfl.net/user/Murai )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pzaN
 */

// forked from Event's Human Clock
package {
    import org.libspark.betweenas3.BetweenAS3;

    import flash.display.BlendMode;
    import flash.display.Sprite;
    import flash.display.StageQuality;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.filters.GlowFilter;
    import flash.geom.ColorTransform;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundMixer;
    import flash.net.URLRequest;
    import flash.utils.ByteArray;

    [SWF(backgroundColor="#000000", frameRate="60", width="465", height="465")]

    public class FlashTest extends Sprite {

        private var leftRightSpList:Array;
        private var snd:Sound;
        private var FFTswitch:Boolean = false;
        private var grows:Array;
        private var particleContainer:Sprite;
        private var filter:BlurFilter;
        private var color:Sprite;
        private var count:int;
        private var vol:Number;
        private var clock:Clock;

        function FlashTest() {
            
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            
            stage.quality = StageQuality.LOW;
            grows = [new GlowFilter(0xCCCCCC, 1, 4, 4, 4),new GlowFilter(0x888888, 1, 4, 4, 4),new GlowFilter(0xFFFFFF, 1, 4, 4, 4)];                
                
            playSound("http://www.takasumi-nagai.com/soundfiles/sound001.mp3");
            
            addChild(particleContainer = new Sprite());
            addChild(clock = new Clock());
            addChild(color = new Sprite());
            with(color) {
                graphics.beginFill(0x000000, 1);
                graphics.drawRect(-5, -5, 10, 10);
                graphics.endFill();
            };
            color.blendMode = BlendMode.ADD;
            
            
            filter = new BlurFilter(2, 2, 2);
            leftRightSpList = makeLeftRightSpList();
            
            count = 0;
            
            Wonderfl.capture_delay(5.8);
            
            addEventListener(Event.ENTER_FRAME, render);
        }

        private function change():void {
            
            var hex:uint = [0xBA0718,0x127996,0x00BDAA,0xEBAC27,0xDB3615][count++ % 5];
            color.transform.colorTransform = new ColorTransform(0, 0, 0, 1, hex >> 16 & 0xff, hex >> 8 & 0xff, hex & 0xff, 1);
            color.width = stage.stageWidth;
            color.height = stage.stageHeight;
            color.x = 465 / 2;
            color.y = 465 / 2;
            
            BetweenAS3.tween(color, {alpha:1}, {alpha:0.5}, 0.5).gotoAndPlay(0);
        }

        private function playSound(sndUrl:String):void {
            snd = new Sound();
            var context:SoundLoaderContext = new SoundLoaderContext(10, true);
            var req:URLRequest = new URLRequest(sndUrl);
            snd.load(req, context);
            var sndChannel:SoundChannel = new SoundChannel();
            sndChannel = snd.play(0, 9999);
        }

        private function render(event:Event):void {
            var sp:Sprite = new Sprite();
            var bytes:ByteArray = new ByteArray();
            SoundMixer.computeSpectrum(bytes, FFTswitch, 0);
            var i:uint, j:uint;
            for (i = 0;i < 2;i++) {
                var spList:Array = leftRightSpList[i];
                for (j = 0;j < 256;j++) {
                    sp = spList[j];
                    var rf:Number = bytes.readFloat();
                    var scale:Number = Math.max(0.05, 1 + rf * 100);
                    sp.scaleX = scale;
                    sp.scaleY = scale / 5 + 1;
                    
                    sp.filters = ((Math.random() * 10 >> 0) % 2) ? [grows[Math.random() * 3 >> 0]] : null;
                        
                    if(!FFTswitch) {
                        sp.x += sp.x * rf * 5 + 8;
                    } else {
                        sp.x = sp.x * rf * 5 + 8;
                    }
                }
            }
            SoundMixer.computeSpectrum(bytes, false, 60);
            vol = bytes.readFloat();
            if(vol > .25)change();
        }

        private function makeLeftRightSpList():Array {
            var spLRList:Array = new Array();
            var n:uint;
            var i:uint;
            for (n = 0;n < 2;n++) {
                var spList:Array = new Array();
                for (i = 0;i < 256;i++) {
                    var sp:Sprite = new Sprite();
                    sp.graphics.beginFill(0x000000);
                    sp.blendMode = BlendMode.ADD;
                    sp.graphics.drawRect(0, 0, 5, 1);
                    sp.graphics.endFill();
                    sp.y = stage.stageHeight / 256 * i;
                    particleContainer.addChild(sp);
                    spList.push(sp);
                }
                spLRList.push(spList);
            }
            return spLRList;
        }
    }
}

import flash.display.Graphics;
import flash.display.Shape;
import flash.display.Sprite;
import flash.events.TimerEvent;
import flash.utils.Timer;

internal class Clock extends Sprite {

    private var _hour:int;
    private var _min:int;
    private var _sec:int;
    private var _shpSec:Shape;
    private var _shpMin:Shape;
    private var _shpHour:Shape;
    private var _pathCommands:Vector.<int> = Vector.<int>([1,2,2,2,2]);

    public function Clock() {
        initView();
        var timer:Timer = new Timer(100);
        timer.addEventListener(TimerEvent.TIMER, onTimer);
        timer.start();
    }

    private function initView():void {
        var spContainer:Sprite = new Sprite;
        var shp:Shape;
        var t:Number;
        var layer:int;
        for (var i:int = 0;i < 2;++i)
                spContainer.addChild(new Sprite);
            
        for (i = 0;i < 360;++i) {
            shp = new Shape;
            shp.graphics.beginFill(0);
            if (i % 30 == 0) {
                layer = 1;
                drawTrapezium(shp.graphics, 2, 16, 4, 0);
            } 
            shp.rotation = i;
            t = Math.PI / 180 * i - Math.PI / 2;
            shp.x = 180 * Math.cos(t); 
            shp.y = 180 * Math.sin(t);
            Sprite(spContainer.getChildAt(layer)).addChild(shp);
        }
            
            
        _shpHour = new Shape;
        _shpHour.graphics.beginFill(0x000000);
        drawTrapezium(_shpHour.graphics, 6, 90, 10, -5);
        _shpHour.graphics.endFill();
            
        _shpMin = new Shape;
        _shpMin.graphics.beginFill(0x000000);
        drawTrapezium(_shpMin.graphics, 5, 130, 8, -5);
        _shpMin.graphics.endFill();
            
        _shpSec = new Shape;
        _shpSec.graphics.beginFill(0x000000);
        drawTrapezium(_shpSec.graphics, 3, 150, 5, -5);
        _shpSec.graphics.endFill();
            
        spContainer.x = spContainer.y = 465 >> 1;
        addChild(spContainer);
        spContainer = Sprite(spContainer.addChild(new Sprite));
        spContainer.addChild(_shpHour);
        spContainer.addChild(_shpMin);
        spContainer.addChild(_shpSec);
        spContainer.rotation = 180;
            
        onTimer(null);
    }

    private function drawTrapezium($graphics:Graphics, $right:Number, $top:Number, $left:Number, $bottom:Number):void {
        $graphics.drawPath(_pathCommands, Vector.<Number>([$left, $bottom, -$left, $bottom, -$right, $top, $right, $top, $left, $bottom]));
    }

    private function onTimer(e:TimerEvent):void {
        var time:Date = new Date;
        updateView(time.getHours(), time.getMinutes(), time.getSeconds());
    }

    private function updateView($hour:int, $min:int, $sec:int):void {
        if (_sec == $sec) return;
            
        _hour = $hour; 
        _min = $min; 
        _sec = $sec;
        _shpHour.rotation = (_hour % 12) * 30 + _min / 2;
        _shpMin.rotation = _min * 6;
        _shpSec.rotation = _sec * 6;
    }
}
