/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pzYG
 */






package
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.TimerEvent;
    import flash.geom.ColorTransform;
    import flash.filters.BlurFilter;
    import flash.utils.Timer;
    
    [SWF(width = "400", height = "400", backgroundColor = "#000000")]
    
    
    public class Main extends Sprite
    {
        private var box:Box;
        private var time:Timer = new Timer(1250, int.MAX_VALUE);
        private var spriteOverStage:Sprite;

        
        public function Main():void
        {
            spriteOverStage = new Sprite();
            spriteOverStage.graphics.beginFill(0x000000, 1);
            spriteOverStage.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            spriteOverStage.graphics.endFill();
            
            addChild(spriteOverStage);
            
            stage.addEventListener(Event.ENTER_FRAME, update);
            time.addEventListener(TimerEvent.TIMER, backgroundColorChange);
            time.start();
        }

        
        private function update(e:Event):void
        {
            box = new Box(0, 0, 25);
            
            box.x = Math.random() * stage.stageWidth;
            box.y = Math.random() * stage.stageHeight;
            
            box.scaleX = box.scaleY = Math.random() * 1;
            box.filters.push(new BlurFilter(60, 32, 3));
            
            addChild(box);
            
        }
        
        
        private function backgroundColorChange(e:TimerEvent):void
        {
            var randomColor:ColorTransform = this.transform.colorTransform;
            randomColor.color = Math.random() * 0xFFFFFF;
            
            spriteOverStage.transform.colorTransform = randomColor;
        }
        
    }
}




//Internal classes

import flash.display.Sprite;
import flash.events.Event;

internal class Box extends Sprite
{
    public function Box(  x:int, y:int, radius:int  ):void
    {
        this.graphics.beginFill(Math.random() * 0xFFFFFF, 1);
        this.graphics.drawRect(x, y, width, height);
        this.graphics.drawCircle(x, y, radius);
        this.graphics.endFill();
        //this.graphics.lineStyle(2, 0x000000, 1);   //(originally the first line of code in function)
        
        this.addEventListener(Event.ENTER_FRAME, update);
    }
    
    
    private function update(e:Event):void
    {
        this.alpha -= 0.01;
        
        if (this.alpha <= 0)
        {
            if (this.parent)
            {
                this.parent.removeChild(this);
            }
        }
    
    }
}