/**
 * Copyright kawamura ( http://wonderfl.net/user/kawamura )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pz62
 */

package  
{
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.Event;
    import net.hires.debug.Stats;
    
    /**
     * ...
     * @author jaiko
     */
    [SWF(width="465", height="465", frameRate="60", backgroundColor="0x000000")]
    public class Main extends flash.display.Sprite 
    {
        
        public function Main() 
        {
            super();
            
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            var circleManager:CircleManager = new CircleManager();
            addChild(circleManager);
            var background:Sprite = new Sprite();
            addChildAt(background,0);
            var g:Graphics = background.graphics;
            g.beginFill(0x000000);
            g.drawRect(0,0,465,465);
        }
        
    }

}

import flash.display.Sprite;
import flash.events.Event;
import net.hires.debug.Stats;

/**
 * ...
 * @author jaiko
 */
class CircleManager extends Sprite 
{
    
    private const OFFSET:Number = 100;
    private var cirlceList:Array;
    public function CircleManager() 
    {
        super();
        if (stage) init(null);
        else addEventListener(Event.ADDED_TO_STAGE, init);
    }
    
    private function init(e:Event):void 
    {
        removeEventListener(Event.ADDED_TO_STAGE, init);
        //
        layout();
    }
    
    private function layout():void 
    {
        var i:uint;
        var n:uint;
        var circle:Circle;
        
        var _w:uint = Math.floor(stage.stageWidth / OFFSET) + 1;
        var _h:uint = (stage.stageHeight / OFFSET)+ 2;
        var sx:Number = 0.5* OFFSET + ((OFFSET * _w) - stage.stageWidth) * -0.5;
        var sy:Number = 0.5 * OFFSET + ( (OFFSET * _h ) - stage.stageHeight ) * -0.5;
        cirlceList = [];
        n =  (_w * _h);
        for (i = 0; i < n; i++)
        {
            circle = new Circle();
            addChild(circle);
            circle.x = sx + OFFSET * (i % _w);
            circle.y = sy + OFFSET * Math.floor(i / _w);
            circle.onEnterFrame();
            cirlceList.push(circle);
        }
        addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        
        var stats:Stats = new Stats();
        addChild(stats);
    }
    private function enterFrameHandler(e:Event):void 
    {
        var i:uint;
        var n:uint;
        var circle:Circle;
        //
        n = cirlceList.length;
        for (i = 0; i < n; i++)
        {
            circle = cirlceList[i];
            circle.onEnterFrame();
        }
    }
}


import flash.display.GradientType;
import flash.display.Graphics;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.events.TimerEvent;
import flash.utils.Timer;
class Circle extends Sprite 
{
    private const MEMBER:uint = 100;
    private const RADIUS:Number = 40;
    private var rotationalSpeed:Number;
    private var constantRotationalSpeed:Number;
    private var velocityRotationalSpeed:Number = 0;
    private var random:Number;
    private var multiple:uint;
    private var insideDiameter:Number;
    //
    private var timer:Timer;
    private var pointList:Array;

    
    public function Circle() 
    {
        super();
        if (stage) init(null);
        else addEventListener(Event.ADDED_TO_STAGE, init);
    }
    public function onEnterFrame():void
    {
        var i:uint;
        var n:uint;
        var circlePoint:CirclePoint;
        /**/
        var theta:Number;
        var _x:Number;
        var _y:Number;
        var r:Number 
        var radius:Number;
        //
        var aInside:Number;
        var inside:Number;
        //
        velocityRotationalSpeed *= 0.95;
        rotationalSpeed += constantRotationalSpeed + velocityRotationalSpeed;
        //
        n = pointList.length;
        for (i = 0; i < n; i++)
        {
            circlePoint = pointList[i];
            aInside = 0.1 *( insideDiameter - circlePoint.insideDiameter)
            circlePoint.insideSpeed += aInside - 0.1 * circlePoint.insideSpeed;
            
            circlePoint.insideDiameter += circlePoint.insideSpeed;
            
            
            theta = random * (2 * Math.PI * (i / n)) + rotationalSpeed;
            
            r = RADIUS * ((1 + Math.cos(multiple * 2 * Math.PI * (i / n))) * 0.5);
            radius = (RADIUS - circlePoint.insideDiameter) * ( r / RADIUS) + circlePoint.insideDiameter;
            _x = radius * Math.cos(theta);
            _y = radius * Math.sin(theta);
            //
            circlePoint.x = _x;
            circlePoint.y = _y;
        }
    }
    
    
    private function init(e:Event):void 
    {
        removeEventListener(Event.ADDED_TO_STAGE, init);
        //
        layout();
    }
    
    private function layout():void 
    {
        var i:uint;
        var n:uint;
        
        var circlePoint:CirclePoint;
        var container:Sprite = new Sprite();
        addChild(container);

        
        random = 100 * Math.random();
        random *= random;
        random = Math.floor(random);

        insideDiameter = 30 * Math.random();
        
        rotationalSpeed = 0;
        constantRotationalSpeed = (0.01 + 0.99 * Math.random()) * 0.03;
        
        multiple = Math.floor(50 * Math.random()) +1;
        
        pointList = [];
        n = MEMBER;
        for (i = 0; i < n; i++)
        {
            circlePoint = new CirclePoint();
            
            container.addChild(circlePoint);
            circlePoint.insideDiameter = insideDiameter;
            circlePoint.insideSpeed = 0;
            pointList[i] = circlePoint;
        }
        timer = new Timer(2000, 1);
        timer.addEventListener(TimerEvent.TIMER , timerHandler);
        timer.start();
    }
    
    private function timerHandler(event:TimerEvent):void {
        var i:uint;
        var n:uint;
        var circlePoint:CirclePoint;
        var power:Number = 0.1 + 0.05 * Math.random();
        velocityRotationalSpeed =  power;
        
        n = pointList.length;
        for (i = 0; i < n; i++)
        {
            circlePoint = pointList[i];
            circlePoint.insideSpeed += power * 50; 
        }
        timer = new Timer(2000, 1);
        timer.addEventListener(TimerEvent.TIMER , timerHandler);
        timer.start();
    }
}
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Graphics;
import flash.display.Sprite;
import flash.events.Event;

/**
 * ...
 * @author jaiko
 */
class CirclePoint extends Sprite 
{
    private var _insideDiameter:Number;
    private var _insideSpeed:Number = 0;
    public function CirclePoint() 
    {
        super();
        if (stage) init(null);
        else addEventListener(Event.ADDED_TO_STAGE, init);
    }
    
    private function init(e:Event):void 
    {
        removeEventListener(Event.ADDED_TO_STAGE, init);
        //
        layout();
    }
    
    private function layout():void 
    {
        var g:Graphics;
        var bmd:BitmapData;
        var bm:Bitmap;
        var sprite:Sprite = new Sprite();
        g = sprite.graphics;
        g.beginFill(0xFFFFFF);
        g.drawRect(0, 0, 1 ,1);
        bmd = new BitmapData(1,1);
        bmd.draw(sprite);
        bm = new Bitmap(bmd, "auto", false);
        addChild(bm);
        bm.x = 0;
        bm.y = 0;
        
    }
    
    public function get insideDiameter():Number 
    {
        return _insideDiameter;
    }
    
    public function set insideDiameter(value:Number):void 
    {
        _insideDiameter = value;
    }
    
    public function get insideSpeed():Number 
    {
        return _insideSpeed;
    }
    
    public function set insideSpeed(value:Number):void 
    {
        _insideSpeed = value;
    }
    
}
