/**
 * Copyright lol_lol ( http://wonderfl.net/user/lol_lol )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pz4R
 */

package {
	import flash.display.Sprite;
    import flash.display.MovieClip;
    import caurina.transitions.Tweener;
    import flash.filters.BlurFilter;
    import flash.events.Event;
    import flash.events.MouseEvent;

    [SWF(backgroundColor = 0x000011, framerate = 60)]
    public class Stars extends MovieClip {
		private var animation:Object;
    		
        public function Stars() {
        		Tweener.init(stage);
        		animation = {
        			transition: "easeInCubic",
        			x: -1 * stage.stageWidth,
        			y : stage.stageHeight,
        			time: 1.2,
        			alpha: 0
        		};
        		
        		addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        protected function onEnterFrame(e:Event):void
        {
        		drawStar();
        }
        
        protected function drawStar():void
        {
        		var _star:MovieClip = new MovieClip();
        		var _color:uint = Math.random() * 0x1000000;
        		var _steps:Array = [
        			{x:6, y:15},
        			{x:19, y:0},
        			{x:-17, y:10},
        			{x:7, y:20},
        			{x:-15, y:-10}
        		];
        		
        		if( !mouseX || !mouseY ) return;
        		
        		var _x:int = mouseX -100 + Math.random() * 100;
        		var _y:int = mouseY - 150 + Math.random() * 150;
        		
        		_star.graphics.beginFill(_color);
        		_star.graphics.moveTo(_x, _y);
        		_steps.forEach(function(_p:Object, i:int, array:Array):void{
        			_x += _p.x;
        			_y += _p.y;
        			_star.graphics.lineTo(_x, _y);
        		});
        		_steps.reverse();
        		_steps.forEach(function(_p:Object, i:int, array:Array):void{
        			_x += _p.x;
        			_y -= _p.y;
        			_star.graphics.lineTo(_x, _y);
        		});
        		_star.graphics.endFill();
        		_star.filters = [new BlurFilter()];
        		
        		addChild(_star);
        		
        		Tweener.addTween(_star, animation);
        }
    }
}