/**
 * Copyright yasurageruheya ( http://wonderfl.net/user/yasurageruheya )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/py7e
 */

package {
	import flash.display.Graphics;
    import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.utils.getTimer;
	import flash.utils.ByteArray;
	import flash.system.System;
    public class FlashTest extends Sprite {
		private var txt:TextField;
		private var spr:Sprite;
		private const COUNT:int = 50000;
		private var pooler:ByteArrayPooler;
        public function FlashTest() {
            // write as3 code here..
            txt = new TextField();
			txt.autoSize = "left";
			
			addChild(txt);
			
			pooler = new ByteArrayPooler();
			
			spr = createBtn("one more test", 0, 300);
			
			spr.addEventListener(MouseEvent.CLICK, test);
			
			test(null);
        }
		
		private function test(e:MouseEvent):void 
		{
			trace("test");
			spr.removeEventListener(MouseEvent.CLICK, test);
			
			var time:int;
			var i:int;
			var byteArray:ByteArray;
			
			time = getTimer();
			i = COUNT;
			
			while (i--)
			{
				byteArray = pooler.getByteArray();
			}
			
			txt.text = "プールしてない状態でプーラーからByteArrayを作ってもらった時間\n" + (getTimer() - time) + " msec\n";
			txt.appendText("メモリ使用量 : " + System.totalMemory + "\n============\n");
			
			time = getTimer();
			i = COUNT;
			
			while (i--)
			{
				byteArray = new ByteArray();
			}
			
			txt.appendText("普通にByteArrayをnewするのにかかった時間\n" + (getTimer() - time) + " msec\n");
			txt.appendText("メモリ使用量 : " + System.totalMemory + "\n============\n");
			
			time = getTimer();
			i = COUNT;
			
			while (i--)
			{
				byteArray = new ByteArray();
				pooler.dispose(byteArray);
			}
			
			txt.appendText("プールするのにかかった時間\n" + (getTimer() - time) + " msec\n");
			txt.appendText("メモリ使用量 : " + System.totalMemory + "\n============\n");
			
			
			time = getTimer();
			i = COUNT;
			
			while (i--)
			{
				byteArray = pooler.getByteArray();
			}
			
			txt.appendText("プールしてる状態でプーラーからByteArrayをもらうのにかかった時間\n" + (getTimer() - time) + " msec\n");
			txt.appendText("メモリ使用量 : " + System.totalMemory + "\n");
			
			
			
			spr.addEventListener(MouseEvent.CLICK, test);
		}
		
		private function createBtn(str:String, x:int, y:int):Sprite
		{
			var txt:TextField = new TextField();
			var spr:Sprite = new Sprite();
			txt.autoSize = "left";
			txt.textColor = 0xFFFFFF;
			txt.text = str;
			txt.selectable = false;
			spr.addChild(txt);
			var g:Graphics = spr.graphics;
			g.beginFill(0, 1);
			g.drawRect(0, 0, spr.width, spr.height);
			g.endFill();
			
			spr.x = x;
			spr.y = y;
			
			addChild(spr);
			
			return spr;
		}
    }
}
import flash.utils.ByteArray;

class ByteArrayPooler
{
	private var pool:Vector.<ByteArray>;
	
	public function getByteArray():ByteArray
	{
		var byteArray:ByteArray
		if (pool.length)
		{
			byteArray = pool.pop();
		}
		else
		{
			byteArray = new ByteArray();
		}
		return byteArray;
	}
	
	public function get length():int
	{
		return pool.length;
	}
	
	public function dispose(byteArray:ByteArray):void
	{
		byteArray.clear();
		pool.push(byteArray);
	}
	
	public function ByteArrayPooler()
	{
		pool = new Vector.<ByteArray>();
	}
}