/**
 * Copyright masuda_nahoko ( http://wonderfl.net/user/masuda_nahoko )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pxNf
 */

// forked from ProjectNya's ひよこちゃんで学ぶwonderfl
////////////////////////////////////////////////////////////////////////////////
// ひよこちゃんで学ぶwonderfl
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1203
////////////////////////////////////////////////////////////////////////////////

package {

	import flash.display.Sprite;
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.system.Security;

	[SWF(backgroundColor="#FFFFFF", width="465", height="465", frameRate="30")]

	public class Main extends Sprite {
		private static var basePath:String = "http://assets.wonderfl.net/images/related_images/";
		private static var sunshinePath:String = "9/9b/9bbe/9bbec77d53bddc5e7a5f2c00abbade6bd641c549";
		private var loader:ChickLoader;
		private static var chickPath:String = "http://www.project-nya.jp/images/flash/chick.swf";
		private var chick:MovieClip;

		public function Main() {
			//Wonderfl.disable_capture();
			Wonderfl.capture_delay(8);
			init();
		}

		private function init():void {
			var sky:Sky = new Sky(465, 350);
			addChild(sky);
			var ground:Ground = new Ground(465, 115);
			addChild(ground);
			ground.y = 350;
			var sun:Sun = new Sun(100);
			addChild(sun);
			sun.x = 10;
			sun.y = 10;
			var shine:PhotoLoader = new PhotoLoader();
			addChild(shine);
			shine.alpha = 0.5;
			shine.load(basePath + sunshinePath);
			loader = new ChickLoader();
			loader.addEventListener(ChickLoader.COMPLETE, complete, false, 0, true);
			loader.load(chickPath);
		}
		private function complete(evt:Event):void {
			loader.removeEventListener(ChickLoader.COMPLETE, complete);
			chick = loader.content;
			addChild(chick);
			chick.x = 232;
			chick.y = 380;
			chick.scaleX = chick.scaleY = 2;
			loader = null;
		}

	}

}


import flash.display.Sprite;
import flash.display.MovieClip;
import flash.display.Loader;
import flash.display.LoaderInfo;
import flash.net.URLRequest;
import flash.events.Event;
import flash.events.IOErrorEvent;
import flash.events.HTTPStatusEvent;
import flash.events.SecurityErrorEvent;
import flash.system.Security;
import flash.system.LoaderContext;

class ChickLoader extends Sprite {
	private var loader:Loader;
	private var info:LoaderInfo;
	public var content:MovieClip;
	public static const IO_ERROR:String = IOErrorEvent.IO_ERROR;
	public static const HTTP_STATUS:String = HTTPStatusEvent.HTTP_STATUS;
	public static const SECURITY_ERROR:String = SecurityErrorEvent.SECURITY_ERROR;
	public static const INIT:String = Event.INIT;
	public static const COMPLETE:String = Event.COMPLETE;

	public function ChickLoader() {
		Security.allowDomain("www.project-nya.jp");
		loader = new Loader();
		info = loader.contentLoaderInfo;
	}

	public function load(file:String):void {
		info.addEventListener(IOErrorEvent.IO_ERROR, ioerror, false, 0, true);
		info.addEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus, false, 0, true);
		info.addEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror, false, 0, true);
		info.addEventListener(Event.INIT, initialize, false, 0, true);
		info.addEventListener(Event.COMPLETE, complete, false, 0, true);
		try {
			loader.load(new URLRequest(file), new LoaderContext(true));
		} catch (err:Error) {
			trace(err.message);
		}
	}
	public function unload():void {
		loader.unload();
	}
	private function ioerror(evt:IOErrorEvent):void {
		loader.unload();
		dispatchEvent(new Event(ChickLoader.IO_ERROR));
	}
	private function httpstatus(evt:HTTPStatusEvent):void {
		dispatchEvent(new Event(ChickLoader.HTTP_STATUS));
	}
	private function securityerror(evt:SecurityErrorEvent):void {
		dispatchEvent(new Event(ChickLoader.SECURITY_ERROR));
	}
	private function initialize(evt:Event):void {
		content = MovieClip(info.content);
		dispatchEvent(new Event(ChickLoader.INIT));
	}
	private function complete(evt:Event):void {
		info.removeEventListener(IOErrorEvent.IO_ERROR, ioerror);
		info.removeEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus);
		info.removeEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror);
		info.removeEventListener(Event.INIT, initialize);
		info.removeEventListener(Event.COMPLETE, complete);
		//addChild(loader);
		dispatchEvent(new Event(ChickLoader.COMPLETE));
	}

}


import flash.display.Shape;
import flash.geom.Matrix;
import flash.display.GradientType;

class Sky extends Shape {
	private static var _width:uint;
	private static var _height:uint;
	private static var color1:uint = 0x3F68AB;
	private static var color2:uint = 0x77B2EE;

	public function Sky(w:uint, h:uint) {
		_width = w;
		_height = h;
		draw();
	}

	private function draw():void {
		var colors:Array = [color1, color2];
		var alphas:Array = [1, 1];
		var ratios:Array = [0, 255];
		var matrix:Matrix = new Matrix();
		matrix.createGradientBox(_width, _height, 0.5*Math.PI, 0, 0);
		graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix);
		graphics.drawRect(0, 0, _width, _height);
		graphics.endFill();
	}

}


import flash.display.Shape;
import flash.geom.Matrix;
import flash.display.GradientType;

class Ground extends Shape {
	private static var _width:uint;
	private static var _height:uint;
	private static var color1:uint = 0x99CC33;
	private static var color2:uint = 0x7EB133;

	public function Ground(w:uint, h:uint) {
		_width = w;
		_height = h;
		draw();
	}

	private function draw():void {
		var colors:Array = [color1, color2];
		var alphas:Array = [1, 1];
		var ratios:Array = [0, 255];
		var matrix:Matrix = new Matrix();
		matrix.createGradientBox(_width, _height, 0.5*Math.PI, 0, 0);
		graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix);
		graphics.drawRect(0, 0, _width, _height);
		graphics.endFill();
	}

}


import flash.display.Shape;
import flash.geom.Matrix;
import flash.display.GradientType;

class Sun extends Shape {
	private static var radius:uint;
	private static var color:uint = 0xFFFFFF;

	public function Sun(r:uint) {
		radius = r;
		draw();
	}

	private function draw():void {
		var colors:Array = [color, color, color];
		var alphas:Array = [1, 0.3, 0];
		var ratios:Array = [25, 102, 231];
		var matrix:Matrix = new Matrix();
		matrix.createGradientBox(radius*2, radius*2, 0, -radius, -radius);
		graphics.beginGradientFill(GradientType.RADIAL, colors, alphas, ratios, matrix);
		graphics.drawCircle(0, 0, radius);
		graphics.endFill();
	}

}


import flash.display.Sprite;
import flash.display.Loader;
import flash.display.LoaderInfo;
import flash.net.URLRequest;
import flash.events.Event;
import flash.events.IOErrorEvent;
import flash.events.HTTPStatusEvent;
import flash.events.SecurityErrorEvent;
import flash.display.Bitmap;
import flash.system.LoaderContext;

class PhotoLoader extends Sprite {
	private var loader:Loader;
	private var info:LoaderInfo;
	public var content:Bitmap;
	private var smoothing:Boolean;
	public static const IO_ERROR:String = IOErrorEvent.IO_ERROR;
	public static const HTTP_STATUS:String = HTTPStatusEvent.HTTP_STATUS;
	public static const SECURITY_ERROR:String = SecurityErrorEvent.SECURITY_ERROR;
	public static const INIT:String = Event.INIT;
	public static const COMPLETE:String = Event.COMPLETE;

	public function PhotoLoader() {
		loader = new Loader();
		info = loader.contentLoaderInfo;
	}

	public function load(file:String, s:Boolean = false):void {
		smoothing = s;
		info.addEventListener(IOErrorEvent.IO_ERROR, ioerror, false, 0, true);
		info.addEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus, false, 0, true);
		info.addEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror, false, 0, true);
		info.addEventListener(Event.INIT, initialize, false, 0, true);
		info.addEventListener(Event.COMPLETE, complete, false, 0, true);
		try {
			loader.load(new URLRequest(file), new LoaderContext(true));
		} catch (err:Error) {
			trace(err.message);
		}
	}
	public function unload():void {
		loader.unload();
	}
	private function ioerror(evt:IOErrorEvent):void {
		loader.unload();
		dispatchEvent(new Event(PhotoLoader.IO_ERROR));
	}
	private function httpstatus(evt:HTTPStatusEvent):void {
		dispatchEvent(new Event(PhotoLoader.HTTP_STATUS));
	}
	private function securityerror(evt:SecurityErrorEvent):void {
		dispatchEvent(new Event(PhotoLoader.SECURITY_ERROR));
	}
	private function initialize(evt:Event):void {
		content = Bitmap(info.content);
		if (smoothing) content.smoothing = true;
		dispatchEvent(new Event(PhotoLoader.INIT));
	}
	private function complete(evt:Event):void {
		info.removeEventListener(IOErrorEvent.IO_ERROR, ioerror);
		info.removeEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus);
		info.removeEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror);
		info.removeEventListener(Event.INIT, initialize);
		info.removeEventListener(Event.COMPLETE, complete);
		addChild(loader);
		dispatchEvent(new Event(PhotoLoader.COMPLETE));
	}

}