/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pxKB
 */

package {
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.geom.Matrix3D;
    import flash.utils.ByteArray;
    import flash.events.ErrorEvent;
    import flash.events.Event;
    import flash.text.TextField;
    import flash.display.Sprite;
    import flash.display3D.Context3D;
    import flash.display3D.Context3DProfile;
    import flash.display3D.Context3DRenderMode;
    import com.adobe.utils.AGALMiniAssembler;
    import flash.display3D.Context3D;
    import flash.display3D.Context3DBlendFactor;
    import flash.display3D.Context3DCompareMode;
    import flash.display3D.Context3DProgramType;
    import flash.display3D.Context3DTriangleFace;
    import flash.display3D.Context3DVertexBufferFormat;
    import flash.display3D.IndexBuffer3D;
    import flash.display3D.VertexBuffer3D;
    import flash.display3D.Program3D;
    import flash.display3D.textures.Texture;
    public class FlashTest extends Sprite {
        
        public var deb:TextField;
        
        public function FlashTest() {
 
            deb = new TextField();
            addChild(deb);
            deb.width = 400;
            deb.text = " debug ";
            
            
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }//ctor
        
        public function init(e:Event=null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            //if (stage == null) { deb.text = "stage null"; }
           // else { deb.text = "stage exist"; }
            //deb.text = "stage > " + stage.stage3Ds[0];
            
            stage.stage3Ds[0].addEventListener(Event.CONTEXT3D_CREATE, contReady);
            stage.stage3Ds[0].addEventListener(ErrorEvent.ERROR, onError);
            stage.stage3Ds[0].requestContext3D(Context3DRenderMode.AUTO);
            
           // deb.text = " reach ";
        }//init
    
        private var context:Context3D;
        
        public function onError(e:ErrorEvent):void
        {
            deb.text = e.text;
            deb.textColor = 0xFF0000FF;
        }//onerror
        
        public function contReady(e:Event):void
        {
            deb.text = "context ready ";
            
            context = stage.stage3Ds[0].context3D;
            deb.text = context.driverInfo;
            deb.textColor = 0xFFffFFff;
            
            //context.addEventListener(ErrorEvent.ERROR, onError);
            
            context.configureBackBuffer(400, 400, 2, true);
        
        
            initProgram(context);    
           
              
           
            createBuffer(context);


            var pic:Bitmap;
            pic = new Bitmap(new BitmapData(400,400,false,0));
            context.clear();
            draw(context);
            context.drawToBitmapData(pic.bitmapData);
            //context.present();            
            addChild(pic);
          
            //stage.addEventListener(Event.ENTER_FRAME, onEnter);
        }//contready
        
        public var prog:Program3D;
        public var bufVert:VertexBuffer3D;
        public var bufFace:IndexBuffer3D;
        
        public function createBuffer(c:Context3D):void
        {
            var p:Number;
            var n:Number;
            var scale:Number;
            var vecFace:Vector.<uint>;
            var vecVert:Vector.<Number>;
            
            scale = 1.0;

            p = 0.5 * scale;
            n = -0.5 * scale;
            
            vecFace  = Vector.<uint>([1, 0, 2, 1, 2, 3]);

            vecVert  = Vector.<Number>([
             n, n, 0.0,
             p, n, 0.0,
             n, p, 0.0,
             p, p, 0.0 ]);
            
             bufVert = c.createVertexBuffer(4, 3);
             bufFace = c.createIndexBuffer(2 * 3);
             
             bufVert.uploadFromVector(vecVert, 0, 4);
             bufFace.uploadFromVector(vecFace, 0, 2 * 3);
        }//createbuffer
        
        public function initProgram(c:Context3D):void
        { 
            prog = c.createProgram();
                       
            var vert:ByteArray;
            var frag:ByteArray;
            var assembler:AGALMiniAssembler = new AGALMiniAssembler();
            
            var code:String;
                code = "";
                code += "m44 op, va0, vc0\n"
                
                    vert = assembler.assemble(Context3DProgramType.VERTEX, code);
                
                code = "";
                code += "move oc, fc0\n";
                
                    frag = assembler.assemble(Context3DProgramType.FRAGMENT, code);

            prog.upload(vert, frag);
 
        }//initprogram;
        
        
        public function onEnter(e:Event):void
        {
            context.clear();
            
            draw(context);          
                      
            context.present();
        }//onenter
        
        
        public var mat:Matrix3D = new Matrix3D();
        public function draw(c:Context3D):void
        {
            var color:Vector.<Number> = Vector.<Number>([1.0,0,0,1.0]);
            
            c.setCulling(Context3DTriangleFace.BACK);
            c.setProgram(prog);
            
            c.setProgramConstantsFromMatrix(Context3DProgramType.VERTEX, 0, mat, true); 
            c.setProgramConstantsFromVector(Context3DProgramType.FRAGMENT, 0, color);

            c.setVertexBufferAt(0, bufVert, 0, Context3DVertexBufferFormat.FLOAT_3);    
            c.drawTriangles(bufFace, 0, 2);
    
            
        }//draw
        
        
        
    }//classend
}