/**
 * Copyright fluxus ( http://wonderfl.net/user/fluxus )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pxA9
 */

// forked from ProjectNya's Away3D [light effect] + Tween24
////////////////////////////////////////////////////////////////////////////////
// Away3D [light effect] + Tween24
//
// [Away3D] 光の効果 (2)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1794
//
// @clockmaker先生 (http://wonderfl.net/user/clockmaker) の
// http://clockmaker.jp/blog/2012/03/away3d_linesegment/ を参考にしたよ。
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.display.StageAlign;
    import flash.system.System;
    import flash.events.Event;
    import flash.geom.Vector3D;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import away3d.Away3D;
    import away3d.containers.View3D;
    import away3d.containers.Scene3D;
    import away3d.cameras.Camera3D;
    import away3d.containers.ObjectContainer3D;
    import away3d.entities.SegmentSet;
    import away3d.primitives.LineSegment;
    import away3d.filters.RadialBlurFilter3D;
    import away3d.debug.AwayStats;
    import a24.tween.Tween24;
    import a24.tween.events.Tween24Event;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="60")]

    public class Main extends Sprite {
        private var view:View3D;
        private var scene:Scene3D;
        private var camera:Camera3D;
        private var container:ObjectContainer3D;
        private var lights:Array;
        private var types:Array;
        private var vectors:Vector.<Vector3D>;
        private static var radius:uint = 500;
        private var angle:Number = 90;
        private var degree:Number = 0;
        private static var depression:uint = 30;
        private static var radian:Number = Math.PI/180;
        private static var center:Vector3D = new Vector3D();
        private var stats:AwayStats;
        //private var source:BitmapData = new BitmapData(465, 465, false, 0x000000);

        public function Main() {
            Wonderfl.disable_capture();
            //addChild(new Bitmap(source));
            //
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            System.pauseForGCIfCollectionImminent(1);
            init();
            stats = new AwayStats(view);
            addChild(stats);
            stats.x = 340;
        }

        private function init():void {
            types = new Array();
            types.push({lines: 1600, color: 0x00CCFF, scale: 0.4});
            types.push({lines: 3200, color: 0x3399FF, scale: 1});
            vectors = new Vector.<Vector3D>();
            for (var n:uint = 0; n < 3200; n++) {
                var vector:Vector3D = createSphereVector(Math.random()*360, Math.random()*360, 120);
                vectors.push(vector);
            }
            //
            view = new View3D();
            scene = view.scene;
            camera = view.camera;
            addChild(view);
            setup();
            initialize();
            //
            addEventListener(Event.ENTER_FRAME, render, false, 0, true);
            start();
        }
        private function setup():void {
            view.backgroundColor = 0x000000;
            //view.antiAlias = 4;
            view.filters3d = [new RadialBlurFilter3D(4, 2, 1, - 0.4, 0.5, 0.5)];
            //
            camera.x = 0;
            camera.y = 0;
            camera.z = - radius;
        }
        private function initialize():void {
            container = new ObjectContainer3D();
            scene.addChild(container);
            //
            lights = new Array();
            for (var n:uint = 0; n < types.length; n++) {
                var light:SegmentSet = new SegmentSet();
                var type:Object = types[n];
                light.scale(type.scale);
                lights.push(light);
                for (var t:uint = 0; t < type.lines; t++) {
                    var vector:Vector3D = vectors[t];
                    var start:Vector3D = vector.clone();
                    var end:Vector3D = vector.clone();
                    end.scaleBy(1.1);
                    var segment:LineSegment = new LineSegment(start, end, type.color, 0x000000, 1);
                    light.addSegment(segment);
                }
                container.addChild(light);
            }
        }
        private function render(evt:Event):void {
            angle += 1;
            degree += 2;
            var dip:Number = depression*Math.sin(degree*radian);
            camera.x = radius*Math.cos(angle*radian)*Math.cos(dip*radian);
            camera.y = radius*Math.sin(dip*radian);
            camera.z = radius*Math.sin(angle*radian)*Math.cos(dip*radian);
            camera.lookAt(center);
            view.render();
            //view.renderer.queueSnapshot(source);
        }
        private function start():void {
            var light1:SegmentSet = lights[0];
            var light2:SegmentSet = lights[1];
            var atween:Tween24 = Tween24.parallel(
                Tween24.serial(
                    Tween24.tween(light1, 1.2, Tween24.ease.CubicIn).scaleXYZ(0.8, 0.8, 0.8), 
                    Tween24.tween(light1, 0.8, Tween24.ease.CubicOut).scaleXYZ(0.4, 0.4, 0.4)
                ), 
                Tween24.serial(
                    Tween24.tween(light2, 1.2, Tween24.ease.CubicIn).scaleXYZ(1.2, 1.2, 1.2), 
                    Tween24.tween(light2, 0.8, Tween24.ease.CubicOut).scaleXYZ(1, 1, 1)
                )
            ).delay(2);
            atween.addEventListener(Tween24Event.COMPLETE, complete, false, 0, true);
            atween.play();
        }
        private function complete(evt:Tween24Event):void {
            evt.target.removeEventListener(Tween24Event.COMPLETE, complete);
            start();
        }
        private function createSphereVector(a:Number, b:Number, r:Number):Vector3D {
            var px:Number = r*Math.cos(a*radian)*Math.cos(b*radian);
            var py:Number = r*Math.sin(a*radian);
            var pz:Number = r*Math.cos(a*radian)*Math.sin(b*radian);
            var vector:Vector3D = new Vector3D(px, py, pz);
            return vector;
        }
        
    }

}
