/**
 * Copyright peso ( http://wonderfl.net/user/peso )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/px6a
 */

package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.DisplayObject;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    
    import idv.cjcat.stardust.common.actions.Age;
    import idv.cjcat.stardust.common.actions.AlphaCurve;
    import idv.cjcat.stardust.common.actions.DeathLife;
    import idv.cjcat.stardust.common.actions.ScaleCurve;
    import idv.cjcat.stardust.common.clocks.SteadyClock;
    import idv.cjcat.stardust.common.initializers.Life;
    import idv.cjcat.stardust.common.initializers.Scale;
    import idv.cjcat.stardust.common.math.UniformRandom;
    import idv.cjcat.stardust.twoD.actions.Accelerate;
    import idv.cjcat.stardust.twoD.actions.DeathZone;
    import idv.cjcat.stardust.twoD.actions.Move;
    import idv.cjcat.stardust.twoD.emitters.Emitter2D;
    import idv.cjcat.stardust.twoD.handlers.DisplayObjectHandler;
    import idv.cjcat.stardust.twoD.initializers.DisplayObjectClass;
    import idv.cjcat.stardust.twoD.initializers.Position;
    import idv.cjcat.stardust.twoD.initializers.Velocity;
    import idv.cjcat.stardust.twoD.zones.LazySectorZone;
    import idv.cjcat.stardust.twoD.zones.SinglePoint;
    
    [SWF(width=465, height=465, backgroundColor=0)]
    public class particle_sample01 extends Sprite
    {
        private var emitter:Emitter2D;
        private var point:SinglePoint;
        
        private var blur:BlurFilter = new BlurFilter(5, 5);
        
        private var canvas:Bitmap;
        
        private var sp:Sprite = new Sprite();
        
        public function particle_sample01()
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            canvas = new Bitmap(new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x000000));
            
            addChild(sp);
            addChild(canvas);
            
            var clock:SteadyClock = new SteadyClock(1);
            emitter = new Emitter2D(clock);
            
            point = new SinglePoint();
            emitter.addInitializer(new DisplayObjectClass(Circle));
            emitter.addInitializer(new Velocity(new LazySectorZone(4, 0.5)));
            emitter.addInitializer(new Life(new UniformRandom(30, 0)));
            emitter.addInitializer(new Scale(new UniformRandom(1, 0.5)));
            emitter.addInitializer(new Position(point));
            
            emitter.addAction(new Age());
            emitter.addAction(new DeathLife());
            
            var alph:AlphaCurve = new AlphaCurve(0, 30);
            alph.inAlpha = 1;
            alph.outAlpha = 0;
            emitter.addAction(alph);
            
            emitter.addAction(new Move());
            emitter.particleHandler = new DisplayObjectHandler(sp);
            
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function loop(e:Event):void{
            canvas.bitmapData.lock();
            
            point.x = mouseX;
            point.y = mouseY;
            emitter.step();
            
            canvas.bitmapData.applyFilter( canvas.bitmapData, canvas.bitmapData.rect, new Point(), blur);
            canvas.bitmapData.colorTransform(canvas.bitmapData.rect, new ColorTransform(1, 1, 1, 1, 0, 0, 0, -1));
            canvas.bitmapData.draw(sp, null, null);
            
            canvas.bitmapData.unlock();
        }
    }
}
import flash.display.Sprite;

class Circle extends Sprite{
    public function Circle(){
        graphics.beginFill(0xFFFFFF * Math.random());
        graphics.drawCircle(0, 0, 5);
        graphics.endFill();
    }
}