/**
 * Copyright majoraze ( http://wonderfl.net/user/majoraze )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pwfd
 */

// forked from majoraze's chain spring basic
// forked from majoraze's basic springing
// forked from majoraze's basic easing
// forked from majoraze's Throwing
package {
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    public class Spring extends Sprite {
        private var spring:Number = .1;
        private var friction:Number = .8;
        private var handles:Array;
        private var numHandles:Number = 3;
        private var ball:Ball;
        
        
        public function Spring() {
            init();
        }
        
        
        private function init():void {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            ball = new Ball(20);
            addChild(ball);
            
            handles = [];
            for (var i:uint = 0; i < numHandles; i++) {
                var handle:Ball = new Ball(10, 0x0000ff);
                handle.x = Math.random() * stage.stageWidth;
                handle.y = Math.random() * stage.stageHeight;
                handle.addEventListener(MouseEvent.MOUSE_DOWN, onPress);
                addChild(handle);
                handles.push(handle);
            }
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            addEventListener(MouseEvent.MOUSE_UP, onRelease);
        }
        
        private function onEnterFrame(e:Event):void {
            
            for (var i:uint = 0; i < numHandles; i++) {
                var handle:Ball = handles[i] as Ball;
                var dx:Number = handle.x - ball.x;
                var dy:Number = handle.y - ball.y;
                ball.vx += dx * spring;
                ball.vy += dy * spring;
            }
            
            ball.vx *= friction;
            ball.vy *= friction;
            ball.x += ball.vx;
            ball.y += ball.vy;
            
            graphics.clear();
            graphics.lineStyle(1);
            for (var k:uint = 0; k < numHandles; k++) {
                graphics.moveTo(ball.x, ball.y);
                graphics.lineTo(handles[k].x, handles[k].y);
            }
        }
        
        private function onPress(e:MouseEvent):void {
            e.target.startDrag();
        }
        
        private function onRelease(e:MouseEvent):void {
            stopDrag();
        }



    }
}



//ball class

import flash.display.Sprite;

class Ball extends Sprite {
    public var radius:Number;
    private var color:uint;
    public var vx:Number = 0;
    public var vy:Number = 0;    
    
    public function Ball(radius:Number = 40, color:uint = 0xff0000) {
        this.radius = radius;
        this.color = color;
        
        init();
    }
    
    public function init():void {
        graphics.beginFill(color);
        graphics.drawCircle(0,0,radius);
        graphics.endFill()
    }
}