/**
 * Copyright nitoyon ( http://wonderfl.net/user/nitoyon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pwfL
 */

package {
    import flash.display.*;
    import flash.events.Event;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.tweens.ITween;
    import org.libspark.betweenas3.easing.*;
    
    public class SquareToDonut extends Sprite {
        public var r:Number = 800;
        public var d:Number = 80;
        public var angle:Number = 5;
        private var msk:Sprite;
        
        public function SquareToDonut() {
            stage.scaleMode = "noScale";
            stage.align = "TL";

            x = y = 240;
            mask = msk = new Sprite();
            addChild(msk);
            draw();

            var tween:ITween = BetweenAS3.delay(BetweenAS3.parallel(
                BetweenAS3.tween(this, { r: 30 }, null, 5, Quint.easeOut),
                BetweenAS3.tween(this, { angle: 360, d: 160 }, null, 5)
            ), .5);
            tween.onUpdate = draw;
            tween.play();
        }

        private function draw():void {
            var g:Graphics = graphics;
            g.clear();

            var w:Number = Math.sin(angle / 180.0 * Math.PI / 2);
            var h:Number = Math.cos(angle / 180.0 * Math.PI / 2);
            var rd:Number = r + d;
            
            g.beginFill(0x003366);
            g.lineStyle(1);
            g.drawCircle(0, h * r, r);
            g.drawCircle(0, h * r, rd);

            g = msk.graphics;
            g.clear();
            g.beginFill(0xffffff);
            g.moveTo(0, h * r);
            g.lineTo(-rd * w, -d * h); // on circle
            if (angle < 180) { // go up
                g.lineTo(-rd * w, h * r - rd);
                g.lineTo( rd * w, h * r - rd);
            } else {
                g.lineTo(-rd, -d * h);
                g.lineTo(-rd, h * r - rd);
                g.lineTo( rd, h * r - rd);
                g.lineTo( rd, -d * h);
            }
            g.lineTo(rd * w, -d * h); // on circle
            g.endFill();
        }
    }
}
