/**
 * Copyright ayataka ( http://wonderfl.net/user/ayataka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pw58
 */

/*
    PV3のText3Dのテスト
*/
package {
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.Sprite;
    import org.papervision3d.view.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.special.*;
    import org.papervision3d.typography.*;
    import org.papervision3d.typography.fonts.*;
    
    public class PV3_Text3D extends BasicView
    {
        public function PV3_Text3D()
        {
            // マテリアル作成
            var m:Letter3DMaterial = new Letter3DMaterial( 0x204dFF )
            m.doubleSided = true; // 裏面
            
            // Text3D作成
            // 表示できる文字はフォントに依存する
            // Helveticaなら日本語は変換できないため、例外が発生する
            _text = new Text3D("ABCDEFG", new HelveticaBold(), m);
            this.scene.addChild( _text );
            this.startRendering();
            
            // とりあえず回しとく
            this.addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }
        
        private function enterFrameHandler(event:Event):void
        {
            _text.rotationY += 5;
        }
        
        private var _text:Text3D;
    }
}
