/**
 * Copyright hoooooonda ( http://wonderfl.net/user/hoooooonda )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pvsz
 */

package {
    import flash.geom.Matrix;
    import flash.net.URLRequest;
    import flash.utils.Proxy;
    import flash.geom.Point;
    import flash.ui.Mouse;
    import flash.events.*;
    import flash.display.*;
    import flash.system.*;
    public class FlashTest extends Sprite {
        public var colorBmd:BitmapData;  
        public var bmpList:Vector.<Bitmap>;
        public const PIXSIZE:int = 1;
        
        public var ball:Sprite;
        public var bBmpd:BitmapData;
        public var objList:Vector.<Object>;
        public var positionList:Vector.<Point>;
        public const GRAVITY:Number = 0.5;
        
        public var imgHolder:Sprite; 
        public var loader:Loader;
        public var loader2:Loader;     
        
        public function FlashTest() {
           Security.loadPolicyFile("http://hr-portfolio.main.jp/crossdomain.xml");
           
           imgHolder = new Sprite();
           addChild(imgHolder);
           imgHolder.mouseChildren = false;
           imgHolder.x = 200;
           
           loader2 = new Loader();
           loader2.load(new URLRequest("http://hr-portfolio.main.jp/test2.png"));
           loader2.contentLoaderInfo.addEventListener(Event.COMPLETE, setItem);
           
           loader = new Loader();
           loader.load(new URLRequest("http://hr-portfolio.main.jp/test.png"));
           loader.contentLoaderInfo.addEventListener(Event.COMPLETE, setBMP);
                      
        }
          
        public function setItem(e:Event):void
        {
            loader2 = e.target.loader;
            imgHolder.addChild(loader2);            
                        
            bBmpd = new BitmapData(imgHolder.width, imgHolder.height, true, 0x00000000);
            var mat:Matrix = new Matrix();
            bBmpd.draw(imgHolder, mat);
            
            imgHolder.addEventListener(MouseEvent.MOUSE_DOWN, onMDown);
            imgHolder.addEventListener(MouseEvent.MOUSE_UP, onMUp);
        }
             
        public function onMDown(e:MouseEvent):void
        {
            e.target.startDrag();   
        }        
        public function onMUp(e:MouseEvent):void
        {
           e.target.stopDrag(); 
        }

       
        public function setBMP(e:Event):void
        {
            var w:int = e.target.loader.width * PIXSIZE;
            var h:int = e.target.loader.height * PIXSIZE;            
            colorBmd = new BitmapData(w, h, true, 0x00000000);
            colorBmd.draw(e.target.loader);
            bmpList = new Vector.<Bitmap>();
            objList = new Vector.<Object>();
            positionList = new Vector.<Point>();
            
            for(var i:int = 0; i < w; i++)
            {
                for(var j:int = 0; j < h; j++)
                {
                    var picColor:String = "0x" + colorBmd.getPixel32(i,j).toString(16);
                    if(picColor.indexOf("0x0") == -1)
                    {
                        var bmpd:BitmapData = new BitmapData(PIXSIZE, PIXSIZE, true, int(picColor));
                        var bmp:Bitmap = new Bitmap(bmpd);
                        bmp.x = i * PIXSIZE + (stage.stageWidth/2 - w/2);
                        bmp.y = j * PIXSIZE + (stage.stageHeight/2 - h/2);
                        addChild(bmp);
                        bmpList.push(bmp);
                        
                        var obj:Object = new Object();
                        obj["flag"] = false;
                        obj["vy"] = 0;
                        objList.push(obj);
                        positionList.push(new Point(Math.random()*4-2, Math.random()*10));
                    }
                }
            }
            addEventListener(Event.ENTER_FRAME, move);
        }
        
        public function move(e:Event):void
        {
            for(var i:int = 0; i < bmpList.length; i++)
            {
                var bmp:Bitmap = bmpList[i];
                var bmpd:BitmapData = bmp.bitmapData;              
                if(bmpd.hitTest(new Point(bmp.x, bmp.y), 0, bBmpd, new Point(imgHolder.x, imgHolder.y), 255))
                {
                    objList[i].flag = true;
                }
                if(objList[i].flag)
                {
                    //bmp.x += positionList[i].x;
                    objList[i].vy += GRAVITY;
                    bmp.y += objList[i].vy + positionList[i].y;
                }     
            }
        }
    }
}