/**
 * Copyright demouth ( http://wonderfl.net/user/demouth )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/puJM
 */

// forked from shohei909's Cloud (  forked from: Crowd  )
// forked from demouth's Crowd
package {
    //綺麗だったから,forkした。
    //Crowdにblurかけたら,雲(cloud)になった.
    
    
    import flash.display.StageScaleMode;
    import flash.display.StageQuality;
    import flash.events.Event;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import frocessing.color.ColorHSV;
    import flash.utils.getTimer;
    
    [SWF(frameRate='60' , backgroundColor="0")]
    public class FlashTest extends Sprite{
         public function FlashTest(){
             addChild(new AntMap());
         }
    }
}
import flash.filters.BlurFilter;

import flash.geom.Point;
import flash.display.StageScaleMode;
import flash.display.StageQuality;
import flash.events.Event;
import flash.display.Graphics;
import flash.display.Sprite;
import frocessing.color.ColorHSV;
import flash.utils.getTimer;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.events.*;


class AntMap extends Bitmap {
        private var ant:Ant;
        private var mouse:Ant;
        private var sprite:Sprite = new Sprite();
        private const filter:BlurFilter = new BlurFilter(30,30,1);
        private var baseData:BitmapData;
        private var ants:Vector.<Ant>;
        private const NUM:int = 1000;
        
        public function AntMap() {
            baseData =  new BitmapData(465,465,false,0x000000);
            super( new BitmapData(465,465,false,0x000000) );
            
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init)
        }
        
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            this.stage.quality = StageQuality.LOW;
            this.stage.scaleMode = StageScaleMode.NO_SCALE;
            
            this.ants = new Vector.<Ant>();
            this.mouse = new Ant();
            
            for (var i:int = 0; i < NUM; i++) 
            {
                var ant:Ant = new Ant();
                ant.setTarget( this.mouse );
                
                this.ants.push( ant );
                ant.x = this.stage.stageWidth / 2  + Math.random() * 300 - 150;
                ant.y = this.stage.stageHeight / 2 + Math.random() * 300 - 150;
            }
            
            this.stage.addEventListener( Event.ENTER_FRAME , enterFrameHandler);
            
        }
        
        private function enterFrameHandler(event:Event):void 
        {
            
            sprite.graphics.clear();
            
            var r:Number = 150;
            this.mouse.x = Math.cos(getTimer()*0.009)*r + this.stage.stageWidth/2;
            this.mouse.y = Math.sin(getTimer()*0.015)*r + this.stage.stageHeight/2;
            
            var l:int = this.ants.length;
            
            for (var i:int = 0; i < l; i++) 
            {
                this.ants[i].move();
            }
            
            this.draw();
            
        }
        
        private function draw():void
        {
            var g:Graphics = sprite.graphics;
            var l:int = this.ants.length;
            for (var i:int = 0; i < l; i++) 
            {
                var ant:Ant = this.ants[i];
                var hsv:ColorHSV = new ColorHSV(ant.speed*15 + ((getTimer()*0.01)) , 0.7);
                var toX:Number = ant.x + Math.cos( ant.angle ) * 10 ;
                var toY:Number = ant.y + Math.sin( ant.angle ) * 10 ;
                
                g.lineStyle( 1 , hsv.value);
                g.moveTo( ant.x , ant.y );
                g.lineTo( toX , toY );
            }
            bitmapData.lock();
            bitmapData.draw(sprite);               
            bitmapData.applyFilter(bitmapData,bitmapData.rect,new Point(),filter);
            bitmapData.merge(baseData,bitmapData.rect,new Point(0,0),4,10,30,10); 
            bitmapData.unlock();
        }
}


class Ant
{
    
    public var x:Number = 0;
    
    public var y:Number = 0;
    public var angle:Number = 0;
    public var speed:Number = 0;
    private var target:Ant;
    
    public function Ant() 
    {
    }
    
    public function setTarget(target:Ant):void
    {
        this.target = target;
    }
    public function move():void
    {
        
        if ( this.target )
        {
            var diffX:Number = this.target.x - this.x;
            var diffY:Number = this.target.y - this.y;
            var diff:Number = Math.sqrt( diffX * diffX + diffY * diffY );//直線上の距離
            
            if ( diff > 3 )//一定の距離以上の時は角度を変更する
            {
                var nowAngle:Number = this.angle;
                var toTargetAngle:Number = Math.atan2( diffY , diffX );
                nowAngle += Math.PI * 2;
                toTargetAngle += Math.PI * 2;
                nowAngle %= Math.PI * 2;
                toTargetAngle %= Math.PI * 2;
                
                if ( Math.abs( nowAngle - toTargetAngle ) > Math.PI )
                {
                    if ( nowAngle < toTargetAngle ) nowAngle += Math.PI * 2
                    else nowAngle -= Math.PI * 2;
                }
                var angleStepRatio:Number = 0.9 + Math.random() * 0.1;
                this.angle = nowAngle * angleStepRatio + toTargetAngle * (1-angleStepRatio) ;
            }
            
            //スピードを変更する
            this.speed *= 0.5 + Math.random()*0.4;
            if ( diff > 5 ) this.speed += Math.min( diff , 200) * 0.005 + Math.random()*2;
            
        }
        
        var moveX:Number = Math.cos( this.angle ) * this.speed;
        var moveY:Number = Math.sin( this.angle ) * this.speed;
        
        this.x += moveX;
        this.y += moveY;
        
    }
    
}

