/**
 * Copyright sakef ( http://wonderfl.net/user/sakef )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pttw
 */

/*
    フラクタル。
    再帰の復習です。
*/
package
{
    import caurina.transitions.Tweener;
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.geom.Point;
    
    [SWF(width="465", height="465", backgroundColor="0xFFFFFF", frameRate="40")]
    public class Main extends Sprite
    {
        private static const CENTER_X:Number = 465/2;
        private static const CENTER_Y:Number = 465/2;
        private static const SQUARE_SIZE:Number = 120;
        private static const SQUARE_MIN:Number = 5;
        
        private static const CENTER:int=0;
        private static const LEFT_TOP:int=1;
        private static const LEFT_BOTTOM:int=2;
        private static const RIGHT_TOP:int=3;
        private static const RIGHT_BOTTOM:int=4;
        
        private var delay:Number=0;
        
        public function Main()
        {
            delay = 0;
            star(CENTER_X, CENTER_Y, SQUARE_SIZE, CENTER);
        }
        
        // 再帰関数
        public function star(xx:Number, yy:Number, r:int, n:int):void
        {
            if (r > SQUARE_MIN)
            {
                delay+=0.02;
                
                if (n == CENTER)
                {
                    star(xx + r, yy - r, r / 2, RIGHT_BOTTOM);
                    star(xx - r, yy - r, r / 2, LEFT_BOTTOM);
                    star(xx + r, yy + r, r / 2, RIGHT_TOP);
                    star(xx - r, yy + r, r / 2, LEFT_TOP);
                    
                    createBox(r, delay, xx, yy);
                }
                else if (n == RIGHT_BOTTOM)
                {
                    star(xx + r, yy - r, r / 2, RIGHT_BOTTOM);
                    star(xx - r, yy - r, r / 2, LEFT_BOTTOM);
                    star(xx + r, yy + r, r / 2, RIGHT_TOP);
                    
                    createBox(r, delay, xx, yy);
                }
                else if (n == LEFT_BOTTOM)
                {
                    star(xx + r, yy - r, r / 2, RIGHT_BOTTOM);
                    star(xx - r, yy - r, r / 2, LEFT_BOTTOM);
                    star(xx - r, yy + r, r / 2, LEFT_TOP);
                    
                    createBox(r, delay, xx, yy);
                }
                else if (n == RIGHT_TOP)
                {
                    star(xx + r, yy - r, r / 2, RIGHT_BOTTOM);
                    star(xx + r, yy + r, r / 2, RIGHT_TOP);
                    star(xx - r, yy + r, r / 2, LEFT_TOP);
                    
                    createBox(r, delay, xx, yy);
                }
                else if (n == LEFT_TOP)
                {
                    star(xx - r, yy - r, r / 2, LEFT_BOTTOM);
                    star(xx + r, yy + r, r / 2, RIGHT_TOP);
                    star(xx - r, yy + r, r / 2, LEFT_TOP);
                    
                    createBox(r, delay, xx, yy);
                }
            }
        }
        
        // 四角形を描く関数
        private function createBox(r:Number, delay:Number, x:Number, y:Number):void
        {
            var shape:Shape = addChild(new Shape) as Shape;
            var g:Graphics = shape.graphics;
            
            g.beginFill(0xffffff * Math.random(), 0.5);
            g.drawRect(-r, -r, r*2, r*2);
            g.endFill();
            
            shape.x = x;
            shape.y = y;
            shape.scaleX = shape.scaleY = 0;
            Tweener.addTween(shape, {scaleX:1, scaleY:1, time:3, delay:delay, transition:"easeOutBounce"});
        }
    }
}

