/**
 * Copyright actionscriptbible ( http://wonderfl.net/user/actionscriptbible )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ptsA
 */

package {
  import flash.display.*;
  import flash.events.*;
  import flash.text.*;
  import flash.net.URLRequest;

  public class ch27ex2 extends Sprite {
    protected var preloadTF:TextField;
    protected var l:Loader;
    public function ch27ex2() {
      l = new Loader();
      //photo   (CC-BY) Roger Braunstein
      //source  http://www.flickr.com/photos/rogerimp/2940373537/
      var url:String = "http://actionscriptbible.com/files/heiwadoori.jpg";
      l.load(new URLRequest(url));
      
      //this textfield will show the progress of the loading process.
      preloadTF = new TextField();
      preloadTF.defaultTextFormat = new TextFormat("_sans", 12, 0);
      preloadTF.autoSize = TextFieldAutoSize.LEFT;
      addChild(preloadTF);
      
      l.contentLoaderInfo.addEventListener(Event.COMPLETE, onComplete);
      l.contentLoaderInfo.addEventListener(ProgressEvent.PROGRESS, onProgress);
      l.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, onError);
    }
    
    protected function onComplete(event:Event):void {
      var info:LoaderInfo = LoaderInfo(event.target);
      preloadTF.text = "loaded " + info.width + "x" + info.height + " " + 
        (info.bytesTotal>>10) + "kb" + " image of type " + info.contentType;
      l.y = preloadTF.textHeight + 4;
      addChild(l);
    }
    
    protected function onProgress(event:ProgressEvent):void {
      var percent:Number = event.bytesLoaded / event.bytesTotal * 100;
      preloadTF.text = percent.toFixed() + "%";
    }
    
    protected function onError(event:ErrorEvent):void {
      preloadTF.text = event.text;
    }
  }
}