/**
 * Copyright kawamura ( http://wonderfl.net/user/kawamura )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ptKB
 */

/*
渋滞をシミュレーションしてみました。
車を円上に並べます。
それぞれにルールを与えます。
1.毎フレーム中心から90度の方向に進む。
2.前の車に近づきすぎたら減速する。遠くなれば加速する

ステージ上をクリックすると、一つの車の速度が半減します。

まぁ、なにが言いたいかというと、高速道路では、なるべく等速で走った方が良い
っと、いうことを渋滞の中で考えました。
*/
package {
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            // write as3 code here..
            var hw:Hightway=new Hightway()
            addChild(hw)
            hw.init();
            
            var tf:TrafficJam=new TrafficJam(hw);
            addChild(tf)
            tf.init()
        }
    }
}

import flash.display.Sprite;
class Hightway extends Sprite {
    private var n:Number
    private var R:Number
    private var scx:Number;
    private var scy:Number;
    private var c_ar:Array=new Array()
    public function Hightway() {
        // constructor code
        n=100;
        R=200;
    }
    public function init():void{
        scx=stage.stageWidth*.5
        scy=stage.stageHeight*.5
        var i:uint;
        var c:Car
        for(i=0;i<n;i++){
            c=new Car();
            addChild(c)
            var theta:Number=i*2*Math.PI/n
            c.x=scx+R*Math.cos(theta);
            c.y=scy+R*Math.sin(theta);
            c_ar.push(c);
        }
        for(i=0;i<n;i++){
            c=c_ar[i]
            var front:Car;
            if(i==n-1){
                front=c_ar[0]
            }else{
                front=c_ar[i+1]
            }
            c.startMove(front,R);
        }
    }
    public function accident():void{
        var c:Car=c_ar[Math.floor((Math.random()*c_ar.length))];
        c.accident()
        
    }
}
    
import flash.display.Sprite;
import flash.display.Graphics;
import flash.events.Event;
import flash.utils.setTimeout;
import flash.display.MovieClip;

class Car extends Sprite{
    public var _frontcar:Car
    public var _theta:Number;
    public var _R:Number;
    
    private var scx:Number
    private var scy:Number;
    private var _v:Number;
    private var g:Graphics
    private var fd:Number;
    public function Car() {
        // constructor code
        g=this.graphics;
        g.beginFill(0x0000FF);
        g.drawCircle(0,0,1);
        _v=2
    }
    public function init(theta:Number,R:Number,frontcar:Car):void{
        _theta=theta;
        _R=R;
    }
    public function startMove(frontcar:Car,R:Number):void{
        _R=R;
        //
        scx=stage.stageWidth*.5;
        scy=stage.stageHeight*.5;
        //
        _frontcar=frontcar;
        fd=Math.sqrt(Math.pow(_frontcar.x-this.x,2)+Math.pow(_frontcar.y-this.y,2));
        
        addEventListener(Event.ENTER_FRAME,ent)
    }

    public function accident():void{
        _v*=.5;
        setMark()
        
    }
    //private 
    private function setMark():void{
        var ring:MovieClip=new MovieClip;
        addChild(ring);
        var rg:Graphics=ring.graphics;
        rg.beginFill(0xFF0000,0.5);
        rg.drawCircle(0,0,30);
        ring.scaleX=0;
        ring.scaleY=0;
        ring.addEventListener(Event.ENTER_FRAME,ripple);
    }
    private function ripple(evt:Event):void{
        var ring:MovieClip=evt.currentTarget as MovieClip;
        var dx:Number=1-ring.scaleX;
        ring.scaleX+=dx*0.15;
        ring.scaleY=ring.scaleX;
        ring.alpha=1-ring.scaleX;
        if(dx<0.03){
            ring.removeEventListener(Event.ENTER_FRAME,ripple);
            removeChild(ring);
        }
    }
    private function ent(evt:Event):void{

        var theta:Number=-0.5*Math.PI+Math.atan2(scy-this.y,scx-this.x)
        var d:Number=Math.sqrt(Math.pow(_frontcar.x-this.x,2)+Math.pow(_frontcar.y-this.y,2));
        if(d<fd*.5){
            _v*=0.5
        }else{
            _v+=(2-_v)*0.05;
        }
        //
        if(_v<1){
            g.clear();
            g.beginFill(0xFF0000);
            g.drawCircle(0,0,1);
        }else{
            g.clear();
            g.beginFill(0x0000FF);
            g.drawCircle(0,0,1);
        }
        var _x:Number=this.x+_v*Math.cos(theta);
        var _y:Number=this.y+_v*Math.sin(theta);
        theta=Math.atan2(_y-scy,_x-scx);
        this.x=scx+_R*Math.cos(theta);
        this.y=scy+_R*Math.sin(theta);
    }
}

import com.bit101.components.*;
import flash.events.MouseEvent;
import flash.display.Sprite;

class TrafficJam extends Sprite {
    private var hw:Hightway;
    private var pbtn:PushButton;
    public function TrafficJam(heightway:Hightway):void {
        // constructor code
        hw=heightway;
        
    }
    public function init():void{
        pbtn=new PushButton();
        pbtn.label="Traffic Jam";
        pbtn.x=stage.stageWidth*.5-pbtn.width*.5
        pbtn.y=stage.stageHeight*.5-pbtn.height*.5
        addChild(pbtn)
        pbtn.addEventListener(MouseEvent.CLICK,clk);
    }
    private function clk(evt:MouseEvent):void{
        //pbtn.removeEventListener(MouseEvent.CLICK,clk);
        hw.accident();
    }
}
    