/**
 * Copyright clockmaker ( http://wonderfl.net/user/clockmaker )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/psDY
 */

// forked from clockmaker's [PV3D]外部画像をLoaderを利用して読み込んだ場合の実装方法
package {
    import flash.net.*;
    import flash.system.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.view.*;
    import jp.progression.commands.net.*;
    import jp.progression.commands.lists.*;
    import jp.progression.data.*;

    
    /**
    * Progression 4 を使うと PV3D の
    * 外部画像マテリアルをより簡単に扱えるようになるというデモ
    */
    public class Main extends BasicView {
        public function Main():void {
            new SerialList(null,
                // Load コマンドのプログレスイベントに引っ掛ければ、ローディングバーとか簡単に作成可
                new LoadBitmapData(new URLRequest("http://clockmaker.jp/imgs/mooning-light_300x300.jpg"), {context:new LoaderContext(true)}),
                function():void {
                    // マテリアル(テクスチャ)を BitmapMaterial をして作成
                    var material:BitmapMaterial = new BitmapMaterial(this.latestData);
                        
                    // 球体を作成して画面に表示
                    var o:* = scene.addChild(new Sphere(material, 500, 20, 20));
                                    
                    // ついでに回転でもさせておく
                    addEventListener("enterFrame", function():void { o.yaw(1); singleRender(); });                    
                }
            ).execute();
        }
    }
}
