/**
 * Copyright curvedstraightline ( http://wonderfl.net/user/curvedstraightline )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ps4t
 */

package 
	{
    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.display.MovieClip;
    import flash.events.Event;
    import flash.utils.Timer;
    import gs.*;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    
    [SWF(backgroundColor="0x000000",Rate="25")]
    
    public class Main extends Sprite 
    	{
    		public var _timer:Timer;
    		
    		public var _bp:Bitmap;
    		public var _bmd:BitmapData;
        public function Main() 
        	{
        		_timer = new Timer(1000);
        		_timer.addEventListener("timer",makeCircle);
        		_timer.start();
        }
        
        public function Circle(POINT_X:int,
        		POINT_Y:int,
        		DIAMETER:int,
        		COLOR:Number,
        		NAME:String,
        		NUM:int
        ):void
        {
        		var SIZE:int = Math.floor(Math.random() * 90) + 10;
        		var TIME:Number = 0.1 * NUM;
        		
        		var _sp:Sprite = new Sprite();
        		_sp.graphics.beginFill(COLOR);
        		_sp.graphics.drawCircle(0,0,1);
        		
        		_sp.x = stage.stageWidth / 2;
        		_sp.y = stage.stageHeight / 2;
        		_sp.name = NAME;
        		TweenLite.to(_sp,TIME,
        		{
        			width:SIZE,
        			height:SIZE,
        			x:POINT_X,
        			y:POINT_Y
        		});
        		TweenLite.to(_sp,TIME,
        		{
        			delay:0.7,
        			alpha:0,
        			overwrite:0,
        			onComplete:function(){
        				removeChild(_sp);
        			}
        		});
        		addChild(_sp);
        }
        
        
        public const MC_NUMBER:int=12;
        public const RADIUS:int = 100;
        public const CENTER_X:int = stage.stageWidth / 2;
        public const CENTER_Y:int = stage.stageHeight / 2;
        
        public function makeCircle(evt:Event):void
        {
        		for(var i:int = 1;i<=MC_NUMBER;++i)
        		{
        			var RADIAN:Number = ((360 / MC_NUMBER) * i * Math.PI / 180) - 90;
        			var POINT_X:int = Math.cos(RADIAN) * RADIUS + CENTER_X;
        			var POINT_Y:int = Math.sin(RADIAN) * RADIUS + CENTER_Y;
        			var DIAMETER:int = 10;
        			
        			var COLOR:int;
        			var RED:int = 0x00;
        			var GREEN:int = Math.floor(Math.random() * 0xFF) + 66;
        			var BLUE:int = 0x00;
        			COLOR = RED << 16 | GREEN << 8 | BLUE;
        			
        			var NAME:String = "MC" + String(i);
        			var NUM:int = i;
        			Circle(POINT_X,POINT_Y,DIAMETER,COLOR,NAME,NUM);
        		}
        }
    }
}