/**
 * Copyright mousepancyo ( http://wonderfl.net/user/mousepancyo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/prwE
 */

package  {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.Shader;
    import flash.filters.ShaderFilter;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.geom.Point;
    import flash.geom.Matrix;
    import flash.net.*;
    import flash.geom.ColorTransform;
    
    [SWF(width = "465", height = "465", backgroundColor = "0", frameRate = "30")]
    public class Main extends Sprite{
        private const FILTER_URL:String = "http://www.digifie.jp/files/filters/Spin.pbj";
        
        private var _loader:URLLoader;
        private var _shader:Shader;
        private var _filter:ShaderFilter;
        
        private var _srcBmd:BitmapData;
        private var _bm:Bitmap;
        private var _video:CameraCapture;
        
        private var _p:Point;
        private var _ctf:ColorTransform;
        
        public function Main() {
            Wonderfl.capture_delay(10);
            addChild(new Bitmap(new BitmapData(465, 465, false, 0)));
            _srcBmd = new BitmapData(465, 465, false, 0);
            _bm = new Bitmap(_srcBmd);
            _ctf = new ColorTransform(.8, .8, .8, 1)
            //
            filterLoad();
        }
        
        private function filterLoad():void{
            _loader = new URLLoader;
            _loader.addEventListener(Event.COMPLETE, onLoaded);
            _loader.dataFormat = URLLoaderDataFormat.BINARY;
            _loader.load(new URLRequest(FILTER_URL));
        }
        
        private function onLoaded(e:Event):void{
            _loader.removeEventListener(Event.COMPLETE, onLoaded);
                
            // CreateFilter
            _shader = new Shader(_loader.data);
            _filter = new ShaderFilter(_shader);
            //
            _video = new CameraCapture(320, 240, 10);
            _p = new Point(232, 232)
            addEventListener(Event.ENTER_FRAME, update);
            addChild(_bm);
        }
        
        private function update(e:Event):void{
            _srcBmd.colorTransform(_srcBmd.rect, _ctf);
            _srcBmd.draw(_video, new Matrix(1,0,0,1,72,100), null, "screen");
            // addedFilter
            _srcBmd.applyFilter(_srcBmd, _srcBmd.rect, new Point(), _filter);
            //
            var n1:Number = (mouseX - stage.stageWidth * .5) * .05;
            var n2:Number = mouseY;
            _shader.data.twist.value = [n1];
            _shader.data.radius.value = [n2];
            
            _p.x += (mouseX - _p.x) * .05;
            _p.y += (mouseY - _p.y) * .05;
            
            _shader.data.center.value = [_p.x, _p.y];
        }
        
    }
    
}


// Camera
import flash.media.Video;
import flash.events.Event;
import flash.media.Camera;

class CameraCapture extends Video{
    private var _cam:Camera;
    private var _camW:int;
    private var _camH:int;
    private var _fps:Number;

    public function CameraCapture(camW:Number, camH:Number, fps:Number=30) {
        this.width = camW;
        this.height = camH;
        _camW = camW;
        _camH = camH;
        _fps = fps;
        _cam = Camera.getCamera();
        _cam.setMode(_camW, _camH, _fps);
        this.attachCamera(_cam);
    }
}