/**
 * Copyright termat ( http://wonderfl.net/user/termat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pra5
 */

/*
 * 元ネタ=http://processing.org/learning/topics/multipleparticlesystems.html
 * ただし、「Multiple Particle Systems」ではないかな。
 */
package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;

	[SWF(width = "480", height = "480", backgroundColor = "0x000000", fps = "30")] 
	public class Practice77 extends Sprite{
		private var list:Array;
		private var isDown:Boolean = false;
		
		
		public function Practice77() {
			list = new Array();
			addEventListener(Event.ENTER_FRAME, update);
			stage.addEventListener(MouseEvent.MOUSE_DOWN, function(e:MouseEvent):void { isDown = true; } );
		}
		
		private function update(e:Event):void {
			if (isDown) {
				var n:int = 20 * Math.random()+5;
				for (var i:int = 0; i < n; i++) addParticle();
				isDown = false;
			}
			for (i = 0; i < list.length; i++ ) {
				var p:Particle = list.shift();
				p.move();
				if (p.y < 500) list.push(p);
			}
		}
		
		private function addParticle():void {
			var vx:Number = 2 * Math.random() - 1;
			var vy:Number = -2 * Math.random();
			var p:Particle = new Particle(mouseX, mouseY, vx, vy);
			list.push(p);
			addChild(p);
		}
		
	}
}
import flash.display.MovieClip;

class Particle extends MovieClip {
	private var vx:Number;
	private var vy:Number;
	private var ax:Number=0.0;
	private var ay:Number=0.05;
	private var radius:Number = 10.0;
	private var timer:Number = 100.0;
	
	public function Particle(_x:Number, _y:Number,_vx:Number,_vy:Number):void {
		graphics.beginFill(0xffffff);
		graphics.drawCircle(0, 0, radius);
		graphics.endFill();
		graphics.lineStyle(0.2, 0xffffff);
		graphics.moveTo(0, 0);
		graphics.lineTo(30, 0);
		this.x = _x, this.y = _y;
		vx = _vx, vy = _vy;
	}
	
	public function move():void {
		vx += ax;
		vy += ay;
		x += vx;
		y += vy;
		timer -= 0.8;
		alpha = timer/100.0;
		var tv:Number = (vx * Math.sqrt(vx * vx + vy * vy))*5;
		this.rotationZ += tv;
	}
}