/**
 * Copyright sakef ( http://wonderfl.net/user/sakef )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/prRq
 */

/*
    マイクから音を取ってきてなんちゃってスピード変更。
*/
package
{
    import com.bit101.components.Label;
    import com.bit101.components.PushButton;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.events.ActivityEvent;
    import flash.events.Event;
    import flash.events.SampleDataEvent;
    import flash.media.Microphone;
    import flash.media.Sound;
    import flash.utils.ByteArray;
    
    public class Microphone_test05 extends Sprite
    {
        // 録音時間
        private static const record:int=10;
        
        // マイク関連
        private var mic:Microphone;
        private var bytes:ByteArray;
        private var startTIme:Number;
        private var sound:Sound;
        private var label:Label;
        
        // スピードをかえる変数
        private var flug:int;
        
        public function Microphone_test05():void
        {
            // ステージの設定
            stage.align=StageAlign.TOP_LEFT;
            stage.scaleMode=StageScaleMode.NO_SCALE;
            stage.quality=StageQuality.BEST;
            stage.frameRate=40;
            
            // データを保存するByteArray
            bytes=new ByteArray;
            flug=0;
            
            // マイクの設定
            mic=Microphone.getMicrophone();
            mic.rate=44;
            mic.gain=100;
            mic.setSilenceLevel(0, 0);
            mic.setUseEchoSuppression(true);
            mic.setLoopBack(true);
            mic.addEventListener(SampleDataEvent.SAMPLE_DATA, micSampleData);
            mic.addEventListener(ActivityEvent.ACTIVITY, onStart);
        }
        
        // マイクがアクティブになったら、タイマーを作成して録音開始
        private function onStart(e:ActivityEvent):void
        {
            mic.removeEventListener(ActivityEvent.ACTIVITY, onStart);
            startTIme=(new Date).getTime();
            addEventListener(Event.ENTER_FRAME, onFrame);
            
            label=new Label(this, 30, 30, "");
            label.scaleX=label.scaleY=2;
        }
        
        // 音をByteArrayに書き込む
        private function micSampleData(e:SampleDataEvent):void
        {
            bytes.writeBytes(e.data);
        }
        
        // 秒数をチェックして、録音が終わったら再生開始
        private function onFrame(e:Event):void
        {
            var now:Number=(new Date).getTime();
            var diff:int=(now - startTIme) * 0.001;
            
            label.text="Recording "+record.toString()+" seconds : " + createTimeText(diff);
            
            if (diff >= record)
            {
                removeEventListener(Event.ENTER_FRAME, onFrame);
                mic.removeEventListener(SampleDataEvent.SAMPLE_DATA, micSampleData);
                mic.setLoopBack(false);
                
                label.text="play.";
                var btn1:PushButton=new PushButton(this, 30, 70, "speed down.", function():void{flug=(flug > -3) ? (flug - 1) : (flug);});
                var btn2:PushButton=new PushButton(this, 160, 70, "speed up.", function():void{flug=(flug < 3) ? (flug + 1) : (flug);});
                
                bytes.position=0;
                sound=new Sound;
                sound.addEventListener(SampleDataEvent.SAMPLE_DATA, onPlay);
                sound.play();
            }
        }
        
        // 秒数を時間表示用 mm:ss に整形する関数
        private function createTimeText(time:int):String
        {
            var m:int=(time / 60) >> 0;
            var s:int=(time % 60) >> 0;
            var str:String=((m < 10) ? ("0" + m.toString()) : (m.toString()));
            str+=":" + ((s < 10) ? ("0" + s.toString()) : (s.toString()));
            
            return str;
        }
        
        // 再生 (無限ループ)
        private function onPlay(e:SampleDataEvent):void
        {
            for(var i:int=0; i < 2048; i++)
            {
                var wav:Number=bytes.readFloat();
                
                if(flug < 0)
                {
                    var n:int = -flug + 1;
                    while(n>0)
                    {
                        e.data.writeFloat(wav);
                        e.data.writeFloat(wav);
                        n--;
                    }
                }
                else
                {
                    e.data.writeFloat(wav);
                    e.data.writeFloat(wav);
                    
                    var n:int = flug;
                    while(n > 0) 
                    {
                        if (bytes.bytesAvailable > 0) bytes.position +=4;
                        n--;
                    }
                }
                if (bytes.bytesAvailable <= 0) bytes.position=0;
            }
        }
    }
}