/**
 * Copyright tenasaku ( http://wonderfl.net/user/tenasaku )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/prJY
 */

// 2010年4月15日
// 普通にライフゲーム (Conway's Game of Life) です
// 初期値は面倒なのでランダムにしちゃってます
// デフォルトのフレームレートではちとセワシナイですが、
// グライダーのぺたぺた動く姿はこれくらいのほうがカワイイです

package {
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.utils.*;
    public class FlashTest extends Sprite {
    		private const CELL_SIZE:int = 8;
    		private const NUM_ROWS:int = 58;
    		private const NUM_COLS:int = 58; // 465 = 58x8 + 1 
    		private const NUM_CELLS:int = NUM_ROWS*NUM_COLS;
    		private var bmd:BitmapData;
    		private var oya:Array;
    		private var ko:Array;
    		private function nextGeneration():void {
    			var i:int;
    			for ( i = 0 ; i < NUM_CELLS ; ++i ) {
    				var X:int = i%NUM_COLS;
    				var Y:int = Math.floor(i/NUM_COLS);
    				var cc:uint = ( oya[i] != 0 )?0x000000:0xffffff;
    				bmd.fillRect(new Rectangle(X*CELL_SIZE+1,Y*CELL_SIZE+1,CELL_SIZE-1,CELL_SIZE-1),cc);
    				var Xu:int = (X+1)%NUM_COLS;
    				var Xd:int = (X+NUM_COLS-1)%NUM_COLS;
    				var Yu:int = (Y+1)%NUM_ROWS;
    				var Yd:int = (Y+NUM_ROWS-1)%NUM_ROWS;
    				var s:int = 
    					oya[Xu+Yu*NUM_COLS]
    					+oya[Xu+Y*NUM_COLS]
    					+oya[Xu+Yd*NUM_COLS]
    					+oya[X+Yu*NUM_COLS]
    					+oya[X+Yd*NUM_COLS]
    					+oya[Xd+Yu*NUM_COLS]
    					+oya[Xd+Y*NUM_COLS]
    					+oya[Xd+Yd*NUM_COLS];
    				switch(s) {
    					case 0:ko[i] = 0; break;
    					case 1:ko[i] = 0; break;
    					case 2:break;
    					case 3:ko[i] = 1; break;
    					case 4:ko[i] = 0; break;
    					case 5:ko[i] = 0; break;
    					case 6:ko[i] = 0; break;
    					case 7:ko[i] = 0; break;
    					case 8:ko[i] = 0; break;
    				}
    			}
    			for ( i = 0 ; i < NUM_CELLS ; ++i ) {
    				oya[i] = ko[i];
    			}
    		}
    		
    		private function atEveryFrame(e:Event):void {
			nextGeneration();
    		}
    		
    		private function initialize(e:Event):void {
    			this.removeEventListener(Event.ADDED_TO_STAGE, initialize);
    			stage.align = StageAlign.TOP_LEFT;
    			stage.scaleMode = StageScaleMode.NO_SCALE;
    			bmd = new BitmapData(stage.stageWidth,stage.stageHeight,false,0xffffff);
    			this.addChild(new Bitmap(bmd));
    			oya = new Array(NUM_CELLS);
    			ko = new Array(NUM_CELLS);
    			var i:int;
    			for ( i = 0 ; i < NUM_CELLS ; ++i ) {
    				oya[i] = ( Math.random()<0.4 )?1:0;
    			}
    			stage.addEventListener(Event.ENTER_FRAME, atEveryFrame);
    		}
        public function FlashTest() {
            if ( stage != null ) {
            		initialize(null);
            } else {
            		this.addEventListener(Event.ADDED_TO_STAGE, initialize);
            }
        }
    }
}
