/**
 * Copyright itsDcTurner ( http://wonderfl.net/user/itsDcTurner )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pr6V
 */

// forked from itsDcTurner's Multicoloured Snow
package {
	import flash.display.ShaderParameter;
	import flash.accessibility.Accessibility;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import gs.*;

    [SWF(backgroundColor="#FFFFFF", frameRate=60)]
    public class MultiClass extends Sprite {
    
    		public static const hexArray:Array = [0x9c6f0a, 0xc3a62a, 0xddcf66, 0x2a620a, 0x619e2a, 0x9bcb66, 0xa6501d, 0x761c05];
		public static const hex1:uint = 0xFF0000;
		public static const hex2:uint = 0x00FF00;
		public static const hex3:uint = 0x0000FF;
		    
    		public var xArray:Array = [];
    		public var yArray:Array = [];
    		public var playHead:int = 0;
    		public var totalFrames:int;
    		public var c:Sprite; //  canvas
    		
    		// controls
    		public var panel:Sprite;
    		public var cbArray:Array = [];
    		public var shape_1:Btn;
    		public var shape_2:Btn;
    		
    		public var currentColour:Btn;
		public var currentShape :Btn;
		
		public var hex:uint;
		public var shape:String = "square";
    		
    		
    		
        public function MultiClass() {
			
			stage.addEventListener(MouseEvent.MOUSE_DOWN, downHandler);
			stage.addEventListener(MouseEvent.MOUSE_UP, upHandler);
			
			graphics.beginFill(0x25252525);
			graphics.drawRect(0,0, stage.stageWidth, stage.stageHeight);
			graphics.endFill();
			
			setupControls();
			if(c)removeChild(c);c=null;
			c = new Sprite();
			addChildAt(c, getChildIndex(panel));
		}
		
		private function setupControls():void {
			setupPanel()
			
			for (var i:int = 0; i<hexArray.length ; i++){
				addColourBtn(i);
			}
			
			// shape_1
			shape_1 = new Btn(9998);
			addChild(shape_1);
			shape_1.rect(0x555555);
			shape_1.x = stage.stageWidth - 50;
			shape_1.y = stage.stageHeight - 25;
			
			// shape_2
			shape_2 = new Btn(9999);
			addChild(shape_2);
			shape_2.circ(0x555555);
			shape_2.x = stage.stageWidth - 25;
			shape_2.y = stage.stageHeight - 25;
			
			currentColour = cbArray[0];
			currentShape = shape_1;
			
			hex = hexArray[0];
			currentColour.select();
			
			shape_1.select();
			shape_2.deselect();
			
			addEventListener(Btn.BTN_CLICKED, btn_clickHandler);
		}
		
		private function addColourBtn($index:int):void{
			var cb:Btn = new Btn($index);
			addChild(cb);
			cb.rect(hexArray[$index]);
			cb.x = 10+($index*15);
			cb.y = stage.stageHeight - 25;
			cbArray.push(cb);
			cb.deselect();
		}
		
		private function btn_clickHandler(e:Event):void {
			var tb:Btn = e.target as Btn;
			switch(tb.index){
				default:
				if (currentColour!=tb)tb.select();currentColour.deselect(); currentColour = tb; hex = hexArray[tb.index];
				break;
				
				case 9998:
				if (currentShape!= shape_1)shape_1.select(); currentShape.deselect(); currentShape = shape_1; shape = "square";
				break;
				
				case 9999:
				if (currentShape!= shape_2)shape_2.select(); currentShape.deselect(); currentShape = shape_2; shape = "circle";
				break;
			}
		}
		
		private function setupPanel():void {
			panel = new Sprite();
			addChild(panel);
			panel.graphics.beginFill(0x1F1F1F);
			panel.graphics.drawRect(0, stage.stageHeight - 30, stage.stageWidth, 30);
			panel.graphics.endFill();
			panel.buttonMode = true;
			panel.useHandCursor = false;
		}
		
		
		private function downHandler(e:MouseEvent):void{
			xArray = [];
			yArray = [];
			addEventListener(Event.ENTER_FRAME, record);
			
			
		}
		private function upHandler(e:MouseEvent):void{
			removeEventListener(Event.ENTER_FRAME, record);
			totalFrames = xArray.length;
			playHead=0;
			
			
			
			startPlayback()
		}
		
		private function record(e:Event):void{
			xArray.push(mouseX);
			yArray.push(mouseY);
		}
		
		private function startPlayback():void{
			c.addEventListener(Event.ENTER_FRAME, playback);
		}
		
		private function playback(e:Event):void {	
		
			var s:Shape = new Shape(hex, shape, playHead);
			s.x = xArray[playHead];
			s.y = yArray[playHead];
			c.addChild(s);
			c.addEventListener(Shape.KILL, kill_handler);
			playHead++;
			if (playHead>=totalFrames){
				c.removeEventListener(Event.ENTER_FRAME, playback);
			}
		}
		private function kill_handler(e:Event):void{
			var s:Shape = e.currentTarget as Shape;
			c.removeChild(s);
		}
    }
}


{
import flash.display.Sprite;
import flash.events.Event;
import gs.*;
import gs.easing.*;
	class Shape extends Sprite{
		
		public static const KILL:String = "KILL";
 		public function Shape($colour:uint, $shape:String, $index:int){
 			alpha = 0;
 			graphics.beginFill($colour);
 			var scale:Number = 1 + $index*.2;
 			switch($shape){
 				
 				case "circle":
 				graphics.drawCircle(-(scale*.5),-(scale*.5),scale);
 				break;
 				
 				case "square":
 				graphics.drawRect(-(scale*.5),-(scale*.5),scale, scale);
 			}
			
			graphics.endFill();
			scaleX= scaleY= .01;
			TweenLite.to(this, 3, {alpha:1, scaleX:1, scaleY:1, ease:Elastic.easeOut, onComplete:clearMe});	
		}
		
		private function clearMe():void{
			TweenLite.to(this, 30, {alpha:0, scaleX:.2, scaleY:.2, onComplete:dispatchKill, delay:15});
		}
		
		private function dispatchKill():void{
			dispatchEvent(new Event(KILL));
		}
	}
}

import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import gs.*;
import gs.easing.*;
	class Btn extends Sprite{
		
		private static const btnSize:Number = 15;
		public static const BTN_CLICKED:String = "BTN_CLICKED";
		private var frame:Sprite;
		public var index:int;
		private var selected:Boolean = false;
			
		public function Btn($index:int):void{
			index = $index;
			buttonMode=true;
			frame = new Sprite();
			addChild(frame);
			
			frame.graphics.lineStyle(1, 0xFFFFFF);
			frame.graphics.lineTo(0,btnSize);
			frame.graphics.lineTo(btnSize,btnSize);
			frame.graphics.lineTo(btnSize,0);
			frame.graphics.lineTo(0,0);
			frame.alpha = 0;
			
			addEventListener(MouseEvent.CLICK, click_handler);
			
		}
		
		public function select():void {
			TweenLite.killTweensOf(this);
			TweenLite.to(frame, .4, {alpha:1});
			TweenLite.to(this, .4, {alpha:1});
		}
		
		public function deselect():void {
			TweenLite.killTweensOf(this);
			TweenLite.to(frame, .4, {alpha:0});
			TweenLite.to(this, .4, {alpha:.4});
		}
		
		public function rect($hex:uint):void {
			graphics.beginFill($hex);
			graphics.drawRect(0,0,btnSize, btnSize);
			graphics.endFill();
		}
		
		public function circ($hex:uint):void {
			graphics.beginFill($hex);
			graphics.drawCircle(btnSize*.5,btnSize*.5,btnSize*.5);
			graphics.endFill();
		}
		
		private function click_handler(e:MouseEvent):void {
			dispatchEvent(new Event(BTN_CLICKED, true));
		}
	}
	
		
		
		
		
		