/**
 * Copyright Kay ( http://wonderfl.net/user/Kay )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pr4r
 */

/*
Zバッファ法で描いてみるTEST
・手前のモノから順に描いていく
・手前のモノに隠れて見えないモノは描かない
（この程度ならZソートで普通に表現したほうが…きれいで速いはず）
*/
package {
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.geom.Rectangle;
    import flash.geom.Point;
    import flash.events.Event;
    import frocessing.color.ColorHSL;
    public class TryZbuffer extends Sprite {
        private const SW:Number = stage.stageWidth;
        private const SH:Number = stage.stageHeight;
        private var circles:Array = new Array();
        private var bmd:BitmapData;
        private var bm:Bitmap;
        private var tempSprite:Sprite;
        private var tempBmd:BitmapData;
        private var rect:Rectangle;
        private var point:Point;
        public function TryZbuffer():void {
            
            // 各種描画要素を初期化
            bmd = new BitmapData(SW,SH,true,0);
            bm = new Bitmap(bmd,'auto',true);
            addChild(bm);
            tempBmd = new BitmapData(SW,SH,true,0);
            tempSprite = new Sprite();
            rect = new Rectangle(0,0,SW,SH);
            point = new Point(0,0);
            
            // 配置
            var hsl:ColorHSL = new ColorHSL(0,.75,.5);
            for (var i:int = 0; i < 5; i++) {
                for (var j:int = 0; j < 5; j++) {
                    hsl.h = Math.random() * 360;
                    var circle:Dot = new Dot(SW,SH,hsl.value);
                    circle.x = 100*i+SW/2-200;
                    circle.y = 100*j+SH/2-200;
                    circle.z = Math.random()*200-100;
                    circles.push(circle);
                }
            }
            addEventListener(Event.ENTER_FRAME, circlesMove);
        }
        private function circlesMove(e:Event):void {
            for each (var circle:Dot in circles) {
                circle.z = circle.radius * Math.sin(circle.radian);
                circle.radian+=circle.speed;
            }
            
            // 手前のもの（Z座標が小さい）から描画
            circles.sortOn("z",Array.NUMERIC);
            bmd.fillRect(bmd.rect,0);
            for each (circle in circles) {
                // 初期化
                if(tempSprite.numChildren) tempSprite.removeChildAt(0);
                tempBmd.fillRect(bmd.rect,0);
                // 先に対象を描画して
                tempSprite.addChild(circle);
                tempBmd.draw(tempSprite);
                // その上に表示用BitmapDataをかぶせる
                tempBmd.copyPixels(bmd,rect,point,null,null,true);
                // 表示用BitmapDataを更新
                bmd.copyPixels(tempBmd,rect,point,null,null,true);
            }
        }
    }
}
import flash.display.Sprite;
class Dot extends Sprite {
    public var radian:Number;
    public var radius:Number;
    public var speed:Number;
    public function Dot(w:Number,h:Number,c:int):void {
        radian = Math.random()*Math.PI*2;
        radius = Math.random()*200+200;
        speed = Math.random()*0.1+0.1;
        graphics.beginFill(c);
        graphics.drawCircle(0,0,50);
    }
}