/**
 * Copyright fumix ( http://wonderfl.net/user/fumix )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/pqoS
 */

/*
 * 元ネタ
 * iPoneAppのORBITALを再現（してみたかった）
 * もう少しそれっぽくなるように調整する
 * 
 * パクリ元
 *
 * パーティクル周りはほとんどここのソース
 * Particle Sample Part2 | wonderfl build flash online
 * http://wonderfl.net/code/22a06782b22470146ea62c1040ba435928fbf21c
 * 
 * HSV指定でキレイな虹のグラデーションを作る
 * forked from: Saqoosha challenge for amateurs | wonderfl build flash online
 * http://wonderfl.net/code/c9d20ca02ec68185824de3c939dac44483ce5880
 * 
 */
package {
	import flash.display.Sprite;
	import flash.display.StageQuality;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.events.MouseEvent;

	//import net.hires.debug.Stats;

	[SWF(width="465", height="465", backgroundColor="0x000000", frameRate="30")]  

	public class particleSample extends Sprite {

		private var _particles : Array = [];
		private var _emitter : Emitter;
		private var _rainbowCount : Number;

		// 1フレーム間に発生させる Particle 数
		private const PARTICLE_NUM : uint = 30;

		public function particleSample() {
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.quality = StageQuality.LOW;
			setup();
            //addChild(new Stats());
		}

		private function setup() : void {
			_emitter = new Emitter();
                        _rainbowCount = 0;
			addChild(_emitter);

			for (var i : uint = 0;i < 1000; i++) {
				_particles.push(new Particle());
			}

			addEventListener(Event.ENTER_FRAME, draw);
            
			stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDown);
		}

		private function draw(event : Event) : void {
			_emitter.update();

			for each (var p:Particle in _particles) {
				if (!p.destroy) {
					//p.vy += 0.99;
					/*
					if (p.y >= 400) {
					p.vy *= -0.9;
					}
					 * 
					 */
					p.update();
				}
			}
                        _rainbowCount += 0.02;
                        if(_rainbowCount > 1) _rainbowCount -= 1;
		}

		private function mouseDown(event : MouseEvent) : void {
			addEventListener(Event.ENTER_FRAME, createParticle);
			stage.addEventListener(MouseEvent.MOUSE_UP, mouseUp);
			_emitter.updatePosition();
		}

		private function mouseUp(event : MouseEvent) : void {
			stage.removeEventListener(MouseEvent.MOUSE_UP, mouseUp);
			removeEventListener(Event.ENTER_FRAME, createParticle);
		}

		private function createParticle(event : Event) : void {
			var count : uint = 0;
			for each (var p:Particle in _particles) {
				// 停止している Particle を探す
				if (p.destroy) {
					p.x = _emitter.x;
					p.y = _emitter.y;
					p.init(_rainbowCount);
					addChild(p);
					count++;
				}
				if (count > PARTICLE_NUM) break;
			}
		}
	}
}

import frocessing.color.ColorLerp;

import org.libspark.betweenas3.core.easing.IEasing;
import org.libspark.betweenas3.easing.Linear;

import flash.display.GradientType;
import flash.display.SpreadMethod;
import flash.display.Sprite;
import flash.geom.Matrix;

class Emitter extends Sprite {
	public var vx : Number = 0;
	public var vy : Number = 0;
	public var _d : Number = 0;

	private	var dx : Number = 0;
	private var dy : Number = 0;

	public function Emitter() {       
        //graphics.beginFill(0x808080);
        //graphics.drawCircle(0, 0, 10);
        //graphics.endFill();
        
        //blendMode = "add";
	}

	public function update() : void {
		dx = root.mouseX - x;
		dy = root.mouseY - y;		
		_d = Math.sqrt(dx * dx + dy * dy) * 0.2;
		var rad : Number = Math.atan2(dy, dx);

		vx += Math.cos(rad) * _d;
		vy += Math.sin(rad) * _d;

		vx *= 0.5;
		vy *= 0.5;

		x += vx;
		y += vy;
        //x = root.mouseX;
        //y = root.mouseY;
	}

	public function get d() : Number {
		return _d;
	}
	
	public function updatePosition():void{
		//dx = root.mouseX - x;
		//dy = root.mouseY - y;		
	}
}

class Particle extends Sprite {
	public var vx : Number;
	public var vy : Number;
	public var life : Number;
	public var size : Number;

	private var _count : uint;
	private var _destroy : Boolean;

	private var _grad : Gradation;

	public function Particle() {
		//size = Math.random() * 10;
		size = 10;
        
		_destroy = true;
		// Gradationクラスを作る。任意の数のカラー値を渡すことができる。
		_grad = new Gradation(0xff0000, 0x00ff00, 0x0000ff,0xff0000);
	}

	public function init(d : Number = 0) : void {
		vx = Math.random() * 10 - 5;
		vy = Math.random() * 10 - 5;
		life = Math.random() * 30 + 5;
		_count = 0;
		_destroy = false;

		var color : Number = _grad.getColor(d);
        
		var fillType : String = GradientType.RADIAL;
		//var colors : Array = [color , 0x000000];
		var colors : Array = [color , color];
		var alphas : Array = [100, 0];
		var ratios : Array = [0x00, 0xFF];
		var mat : Matrix = new Matrix();
		mat.createGradientBox(size * 2, size * 2, 0, -size, -size);
		var spreadMethod : String = SpreadMethod.PAD;

		graphics.clear();
		graphics.beginGradientFill(fillType, colors, alphas, ratios, mat, spreadMethod);
		graphics.drawCircle(0, 0, size);
		graphics.endFill();
		graphics.beginFill(0xFFFFFF, 0.8);
		graphics.drawCircle(0, 0, 1);
		graphics.endFill();
        
		//filters = [new BlurFilter(4,4,2)];
        
		// 大量のオブジェクトを重ねるとおかしくなる
		blendMode = "add";
	}

	
	public function update() : void {
		x += vx;
		y += vy;

		_count++;
        
		// 死亡フラグ
		if (life < _count) {
			_destroy = true;
			parent.removeChild(this);
		}
	}

	public function get destroy() : Boolean {
		return _destroy;
	}
}

class Gradation {

	private var _colors : Array;
	private var _easing : IEasing;

	public function Gradation(...args) {
		_colors = args.concat();
		_easing = Linear.linear;
	}

	public function setEasing(easing : IEasing) : void {
		_easing = easing;
	}

	public function getColor(position : Number) : uint {
		position = (position < 0 ? 0 : position > 1 ? 1 : position) * (_colors.length - 1);
		var idx : int = position;
		var alpha : Number = _easing.calculate(position - idx, 0, 1, 1);
		if (alpha == 0) {
			return _colors[idx];
		} else {
			return ColorLerp.lerp(_colors[idx], _colors[idx + 1], alpha);
		}
	}
}


